package org.jboss.ws.client;

import org.jboss.ws.hello.Hello;

import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.Call;

import javax.xml.namespace.QName;

import java.net.URL;

public class HelloClientDII
{
    public static void main(String[] args) 
        throws Exception
    {
        String urlstr   = args[0];
        String argument = args[1];

        System.out.println("Contacting webservice at " + urlstr);

        URL url =  new URL(urlstr);

        String ns        = "http://hello.ws.jboss.org/";
        QName  qname     = new QName(ns, "HelloService");
        QName  port      = new QName(ns, "HelloPort");
        QName  operation = new QName(ns, "hello");

        ServiceFactory factory = ServiceFactory.newInstance();
        Service        service = factory.createService(url, qname);
        Call           call    =  service.createCall(port, operation);

        System.out.println("hello.hello(" + argument + ")");
        System.out.println("output:" + call.invoke(new Object[] {argument}));
    }
}
