package org.jbpm.scheduler.ejbtimer;

import javax.ejb.FinderException;
import javax.naming.Context;
import javax.naming.InitialContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.db.JobSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;
import org.jbpm.scheduler.SchedulerService;

public class EjbSchedulerService implements SchedulerService {

	private static final long serialVersionUID = 1L;

	JobSession jobSession;
	TimerEntityLocal timerEntityLocal;
	TimerEntityLocalHome timerEntityLocalHome;

	public EjbSchedulerService() {
		JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
		if(jbpmContext == null) {
			throw new JbpmException(
					"instantiation of the EjbSchedulerService requires a current JbpmContext");
		}
		this.jobSession = jbpmContext.getJobSession();

		try {
			Context initial = new InitialContext();
			timerEntityLocalHome = (TimerEntityLocalHome) initial
					.lookup("java:comp/env/ejb/LocalTimerEntityBean");
		}
		catch(Exception e) {
			JbpmException jbpmException = new JbpmException(
					"ejb local timer lookup problem", e);
			log.error(e);
			throw jbpmException;
		}
	}

	public void createTimer(Timer timer) {
		log.debug("creating timer " + timer);
		jobSession.saveJob(timer);
		try {
			timerEntityLocal = timerEntityLocalHome.findByPrimaryKey(Long.valueOf(timer.getId()));
			timerEntityLocal.createTimer(timer);
		}
		catch(FinderException ex) {
			log.error(ex.getMessage(), ex);
		}
	}

	public void deleteTimersByName(String timerName, Token token) {
		log.debug("deleting timers by name " + timerName);
		java.util.ArrayList timersList = null;
		try {
			if(timerName.equals("") || timerName == null) {
				timersList = new java.util.ArrayList(timerEntityLocalHome
						.findByTokenId(Long.valueOf(token.getId())));
			}
			else {
				timersList = new java.util.ArrayList(timerEntityLocalHome
						.findByTokenIdAndName(Long.valueOf(token.getId()), timerName));
			}
			java.util.Iterator i = timersList.iterator();
			while(i.hasNext()) {
				TimerEntityLocal localObj = (TimerEntityLocal) i.next();
				localObj.cancelTimersByName(timerName, token);
			}
		}
		catch(FinderException ex) {
			log.error(ex.getMessage(), ex);
		}
		jobSession.cancelTimersByName(timerName, token);
	}

	public void deleteTimersByProcessInstance(ProcessInstance processInstance) {
		log.debug("deleting timers for process instance " + processInstance);
		try {
			java.util.ArrayList timersList = new java.util.ArrayList(
					timerEntityLocalHome.findByProcessInstanceId(Long.valueOf(processInstance.getId())));
			java.util.Iterator i = timersList.iterator();
			while(i.hasNext()) {
				TimerEntityLocal localObj = (TimerEntityLocal) i.next();
				localObj.deleteTimersForProcessInstance(processInstance);
			}
		}
		catch(FinderException ex) {
			log.error(ex.getMessage(), ex);
		}
		jobSession.deleteJobsForProcessInstance(processInstance);
	}

	public void close() {}

	private static Log log = LogFactory.getLog(EjbSchedulerService.class);
}
