/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.gd.jpdl.ui.outline.part;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import org.eclipse.gef.EditPart;
import org.eclipse.ui.IActionFilter;
import org.jbpm.gd.jpdl.model.JpdlElement;
import org.jbpm.gd.jpdl.ui.JpdlLabelProvider;
import org.jbpm.gd.jpdl.ui.policy.TreeItemComponentEditPolicy;
import org.jbpm.gd.jpdl.ui.util.AttributeTester;

public class JpdlElementOutlineEditPart extends JpdlOutlineEditPart implements
		PropertyChangeListener, IActionFilter {
	
	public JpdlElementOutlineEditPart(JpdlElement jpdlElement) {
		super(jpdlElement);
	}
	
	private JpdlElement getJpdlElement() {
		return (JpdlElement)getModel();
	}

	public void activate() {
		if (!isActive()) {
			getJpdlElement().addPropertyChangeListener(this);
			super.activate();
		}
	}
	
	public void deactivate() {
		if (isActive()) {
			getJpdlElement().removePropertyChangeListener(this);
			super.deactivate();
		}
	}		

	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy("ComponentEditPolicy", new TreeItemComponentEditPolicy());		
	}

	protected void handleChildAdd(Object newValue) {
		refreshChildren();
		List children = getChildren();
		for (int i = 0; i < children.size(); i++) {
			EditPart part = (EditPart)children.get(i);
			if (part.getModel() == newValue) {
				part.getViewer().select(part);
			}
		}
	}
	
	public boolean testAttribute(Object target, String name, String value) {
		return AttributeTester.testAttribute(target, name, value);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		String eventName = evt.getPropertyName();
		if (eventName.equals("name")) {
			refreshVisuals();
		}
	}
	
	protected String getIconName() {
		return JpdlLabelProvider.getIconName((JpdlElement)getModel());
	}
	
	protected String getText() {
		return JpdlLabelProvider.getLabel((JpdlElement)getModel()).toLowerCase();
	}
	
}
