package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.JpdlElementFactory;
import org.jbpm.gd.jpdl.model.Script;


public class CreateTimerDomAdapter extends JpdlElementDomAdapter {

	private static HashMap NODE_TYPES = null;
	
	protected Map getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap();
			NODE_TYPES.put("action", "action-element");
			NODE_TYPES.put("script", "action-element");
		}
		return NODE_TYPES;
	}
		
	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		CreateTimer createTimer = (CreateTimer)jpdlElement;
		createTimer.setDueDate(getAttribute("duedate"));
		createTimer.setName(getAttribute("name"));
		createTimer.setRepeat(getAttribute("repeat"));
		createTimer.setTransition(getAttribute("transition"));
		createTimer.addPropertyChangeListener(this);
	}

	protected void initialize() {
		super.initialize();
		CreateTimer createTimer = (CreateTimer)getJpdlElement();
		if (createTimer != null) {
			setAttribute("duedate", createTimer.getDueDate());
			setAttribute("name", createTimer.getName());
			setAttribute("repeat", createTimer.getRepeat());
			setAttribute("transition", createTimer.getTransition());
			addElement(createTimer.getAction());
			addElement(createTimer.getScript());
		}
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("action".equals(evt.getPropertyName())) {
			setElement("action", (AbstractJpdlElement)evt.getOldValue(), (AbstractJpdlElement)evt.getNewValue());
		} else if ("script".equals(evt.getPropertyName())) {
			setElement("script", (AbstractJpdlElement)evt.getOldValue(), (AbstractJpdlElement)evt.getNewValue());
		} else if ("duedate".equals(evt.getPropertyName())) {
			setAttribute("duedate", (String)evt.getNewValue());
		} else if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String)evt.getNewValue());
		} else if ("repeat".equals(evt.getPropertyName())) {
			setAttribute("repeat", (String)evt.getNewValue());
		} else if ("transition".equals(evt.getPropertyName())) {
			setAttribute("transition", (String)evt.getNewValue());
		}
	}
	
	protected void doModelUpdate(String name, String newValue) {
		CreateTimer createTimer = (CreateTimer)getJpdlElement();
		if ("name".equals(name)) {
			createTimer.setName(newValue);
		} else if ("duedate".equals(name)) {
			createTimer.setDueDate(newValue);
		} else if ("repeat".equals(name)) {
			createTimer.setRepeat(newValue);
		} else if ("transition".equals(name)) {
			createTimer.setTransition(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		CreateTimer createTimer = (CreateTimer)getJpdlElement();
		AbstractJpdlElement jpdlElement = JpdlElementFactory.INSTANCE.createByName(child.getElementType());
		child.initialize(jpdlElement);
		if ("action".equals(type)) {
			createTimer.setAction((Action)jpdlElement);
		} else if ("script".equals(type)) {
			createTimer.setScript((Script)jpdlElement);
		}
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		CreateTimer createTimer = (CreateTimer)getJpdlElement();
		if ("action".equals(type)) {
			createTimer.setAction(null);
		} else if ("script".equals(type)) {
			createTimer.setScript(null);
		}
	}
	
}
