package org.jbpm.gd.jpdl.model;

import java.util.ArrayList;
import java.util.List;

public class Delegation extends AbstractJpdlElement {
	
	private String configInfoString;
	private List configInfoElements = new ArrayList();
	private String className;
	private String configType = "field";
	
	public void setConfigInfoString(String newConfigInfo) {
		String oldConfigInfo = configInfoString;
		configInfoString = newConfigInfo;
		firePropertyChange("configInfoString", oldConfigInfo, newConfigInfo);
	}
	
	public String getConfigInfoString() {
		return configInfoString;
	}
	
	public void addConfigInfoElement(ConfigInfoElement configInfoElement) {
		configInfoElements.add(configInfoElement);
		firePropertyChange("configInfoElementAdd", null, configInfoElement);
	}
	
	public void removeConfigInfoElement(ConfigInfoElement configInfoElement) {
		configInfoElements.remove(configInfoElement);
		firePropertyChange("configInfoElementRemove", configInfoElement, null);
	}
	
	public ConfigInfoElement[] getConfigInfoElements() {
		return (ConfigInfoElement[])configInfoElements.toArray(new ConfigInfoElement[configInfoElements.size()]);
	}
	
	public void setClassName(String newClassName) {
		String oldClassName = className;
		className = newClassName;
		firePropertyChange("className", oldClassName, newClassName);
	}
	
	public String getClassName() {
		return className;
	}
	
	public void setConfigType(String newConfigType) {
		if (newConfigType == null) {
			newConfigType = "field";
		}
		String oldConfigType = configType;
		configType = newConfigType;
		firePropertyChange("configType", oldConfigType, newConfigType);
	}
	
	public String getConfigType() {
		return configType;
	}

}
