package org.jbpm.gd.common.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class SemanticElementFactory {
	
	public static final SemanticElementFactory INSTANCE = new SemanticElementFactory();
	
	private SemanticElementFactory() {}
	
	public SemanticElement createByName(String elementName) {
		try {
			IConfigurationElement element = SemanticElementRegistry.getConfigurationElementByName(elementName);
			if (element == null) return null;
			SemanticElement result = (SemanticElement)element.createExecutableExtension("modelClass");
			result.setElementId(element.getNamespaceIdentifier()+ "." + element.getAttribute("id"));
			return result;
		} catch (CoreException e) {
			throw new RuntimeException("Creation of executable extension failed", e);
		}
	}
	
	public SemanticElement createById(String elementId) {
		try {
			IConfigurationElement element = SemanticElementRegistry.getConfigurationElementById(elementId);
			if (element == null) return null;
			SemanticElement result = (SemanticElement)element.createExecutableExtension("modelClass");
			result.setElementId(element.getNamespaceIdentifier()+ "." + element.getAttribute("id"));
			return result;
		} catch (CoreException e) {
			throw new RuntimeException("Creation of executable extension failed", e);
		}
	}
	
}
