/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.sublang.xpath;

import java.util.Collections;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.Context;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.expr.LocationPath;
import org.w3c.dom.Node;

import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.sublang.exe.QueryEvaluator;
import org.jbpm.bpel.xml.BpelConstants;
import org.jbpm.bpel.xml.util.XmlUtil;

/**
 * Default evaluator for queries.
 * @author Alejandro Guzar
 * @version $Revision: 1.6 $ $Date: 2007/07/22 05:57:25 $
 */
class XPathQueryEvaluator extends XPathEvaluator implements QueryEvaluator {

  /**
   * The jBPM configuration object name for the resource describing the function library available
   * to queries.
   */
  public static final String FUNCTIONS_CONFIG_NAME = "resource.query.functions";

  private static final long serialVersionUID = 1L;

  private static final Log log = LogFactory.getLog(XPathQueryEvaluator.class);

  private static final FunctionContext functionLibrary = readFunctionLibrary(FUNCTIONS_CONFIG_NAME);

  XPathQueryEvaluator(String text) throws JaxenException {
    super(text);
  }

  protected FunctionContext createFunctionContext() {
    return functionLibrary;
  }

  protected Context getContext(Object node) {
    Context context = new Context(getContextSupport());
    context.setNodeSet(Collections.singletonList(node));
    return context;
  }

  public Object evaluate(Node contextNode) {
    try {
      List nodeset = selectNodes(contextNode);
      return narrowToSingleNode(nodeset);
    }
    catch (JaxenException e) {
      log.error("query evaluation failed", e);
      throw new BpelFaultException(BpelConstants.FAULT_SUB_LANGUAGE_EXECUTION);
    }
  }

  public void assign(Node contextNode, Object value) {
    try {
      List nodes = selectOrCreateNodes((LocationPath) getRootExpr(), getContext(contextNode));
      XmlUtil.setObjectValue(narrowToSingleNode(nodes), value);
    }
    catch (JaxenException e) {
      log.error("query assignment failed", e);
      throw new BpelFaultException(BpelConstants.FAULT_SUB_LANGUAGE_EXECUTION);
    }
  }
}