/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the JBPM BPEL PUBLIC LICENSE AGREEMENT as
 * published by JBoss Inc.; either version 1.0 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package org.jbpm.bpel.integration.catalog;

import java.util.ArrayList;
import java.util.List;

import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.jbpm.bpel.wsdl.xml.WsdlUtil;

/**
 * @author Alejandro Guzar
 * @version $Revision: 1.4 $ $Date: 2007/07/20 21:18:12 $
 */
public class URLCatalog implements ServiceCatalog {

  private String contextURL;
  private List locations = new ArrayList();
  private DefinitionCatalog definitionCatalog;

  private static final Log log = LogFactory.getLog(URLCatalog.class);

  public String getContextURL() {
    return contextURL;
  }

  public void setContextURL(String contextURL) {
    this.contextURL = contextURL;
  }

  public void addLocation(String location) {
    locations.add(location);
  }

  public List getLocations() {
    return locations;
  }

  public List lookupServices(QName portTypeName) {
    return getDefinitionCatalog().lookupServices(portTypeName);
  }

  public Service lookupService(QName serviceName) {
    return getDefinitionCatalog().lookupService(serviceName);
  }

  private synchronized DefinitionCatalog getDefinitionCatalog() {
    if (definitionCatalog == null) {
      definitionCatalog = new DefinitionCatalog();
      definitionCatalog.addDefinitions(readDefinitions());
    }
    return definitionCatalog;
  }

  private Definition[] readDefinitions() {
    WSDLReader reader = WsdlUtil.getFactory().newWSDLReader();
    int n = locations.size();
    Definition[] definitions = new Definition[n];
    for (int i = 0; i < n; i++) {
      String location = (String) locations.get(i);
      Definition definition;
      try {
        definition = reader.readWSDL(contextURL, location);
      }
      catch (WSDLException e) {
        log.debug("ignoring definition read failure: " + e.getMessage());
        definition = WsdlUtil.getFactory().newDefinition();
      }
      definitions[i] = definition;
    }
    return definitions;
  }
}
