/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.quickstart.test;


import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstart.recipientList.test.SendCBRJMSMessage;
import org.jboss.soa.esb.samples.quickstart.recipientList.test.SendStaticRouterJMSMessage;

/**
 * CI test for the recipientlist quickstart.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class RecipientlistTest extends AbstractQuickstartTestCase {
	private static final String JMS_MESSAGE = "RecipientlistTest message";
	private static final String JMS_CBR_MESSAGE = "<Order sampleData=\"CBR test\" testDate=\"20070518\" routeToFollow=\"both\"><Customer userName=\"user1\" firstName=\"Harry\" lastName=\"Fletcher\" state=\"SD\"/></Order>";
	
	public RecipientlistTest(String name) {
		super(name);
	}

	/* This test is intentionally skipped as of 20070813 - ldimaggi - 
	 * there's some problem with the CBR - the test seems unable to
	 * send the messages to the destinations targetted by the CBR */
	public void skip_testCBRMessage() throws Exception {
		sendCBRJMSMessage();
		Thread.sleep(10000); // wait for message to post.
	}

	public void testStaticMessage() throws Exception {
	    clearMessages() ;
	    sendStaticRouterJMSMessage() ;
	    checkMessages(30000, JMS_MESSAGE, JMS_MESSAGE, JMS_MESSAGE) ;
	}

	public void sendCBRJMSMessage() throws Exception {
		SendCBRJMSMessage sm = new SendCBRJMSMessage();
		sm.setupConnection();
		sm.sendAMessage(JMS_CBR_MESSAGE);
		sm.stop();
	}

	public void sendStaticRouterJMSMessage() throws Exception {
		SendStaticRouterJMSMessage sm = new SendStaticRouterJMSMessage();
		sm.setupConnection();
		sm.sendAMessage(JMS_MESSAGE);
		sm.stop();
	}

	public static Test suite() throws Exception {
		return getDeploySetup(RecipientlistTest.class,
				"QuickstartMessageStoreServer.sar, Quickstart_recipient_list.esb");
	}
}
