/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2007,
 * @author JBoss Inc.
 */
package org.jboss.soa.esb.quickstart.test;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstarts.bpm_orchestration1.test.SendTestMessage;

/**
 * CI test for the bpmorchestration1 test.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class BPMOrchestration1Test extends AbstractQuickstartTestCase {
	private static final String DEPLOY_MESSAGE = "Go Deploy It";
	private static final String START_MESSAGE = "Start It Up";

	public BPMOrchestration1Test(String name) {
		super(name);
	}

	public void testMessage() throws Exception {
	        clearMessages() ;
		sendDeployMessage() ;
		checkMessages(30000, DEPLOY_MESSAGE) ;

                clearMessages() ;
                sendStartMessage() ;
                checkMessages(30000, START_MESSAGE) ;
	}

	public void sendDeployMessage() throws Exception {
		SendTestMessage sm = new SendTestMessage();
		sm.sendMessage(Helpers.getQuickstartLocation("bpm_orchestration1/build/inputdir"), ".deployProcessGW", DEPLOY_MESSAGE);
	}
	
        public void sendStartMessage() throws Exception {
		SendTestMessage stm = new SendTestMessage();
		stm.sendMessage(Helpers.getQuickstartLocation("bpm_orchestration1/build/inputdir"), ".startProcessGW", START_MESSAGE);
	}

	public static Test suite() throws Exception {
		return getDeploySetup(BPMOrchestration1Test.class, "QuickstartMessageStoreServer.sar, Quickstart_bpm_orchestration1.esb");
	}
}
