/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2007
 */

package org.jboss.soa.esb.eclipse.preferences;

import org.eclipse.jface.preference.*;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.jboss.soa.esb.eclipse.template.Activator;
import org.jboss.soa.esb.eclipse.util.ESBUtils;

/**
 * Handle preferences for the ESB plugin.
 * 
 * The following preferences are currently required:
 */
public class ESBPreferencePage extends FieldEditorPreferencePage implements
    IWorkbenchPreferencePage
{
    /**
     * The esb field editor.
     */
    private ESBDirectoryFieldEditor esbEditor ;
    /**
     * The as field editor.
     */
    private ASDirectoryFieldEditor asEditor ;
    /**
     * The profile field editor.
     */
    private ProfileFieldEditor profileEditor;
    
    /**
     * Construct the ESB preference page.
     */
    public ESBPreferencePage()
    {
        super(GRID);
        setPreferenceStore(Activator.getDefault().getPreferenceStore());
        setDescription("ESB preference page");
    }

    /**
     * Creates the field editors for the preferences.
     */
    public void createFieldEditors()
    {
        final String esbLocation = getPreferenceStore().getString(ESBPreferenceConstants.ESB_LOCATION) ;
        
        final boolean enabled = !ESBUtils.isESBServerLocation(esbLocation) ;
        
        final Composite parent = getFieldEditorParent() ;
        
        final ModifyListener validator = new ModifyListener() {
            public void modifyText(ModifyEvent e) {
                setValid(false) ;
            }
        } ;
        
        esbEditor = new ESBDirectoryFieldEditor(parent) ;
        addField(esbEditor) ;
        esbEditor.getTextControl(parent).addModifyListener(validator) ;
        
        asEditor = new ASDirectoryFieldEditor(parent) ;
        addField(asEditor) ;
        asEditor.setEnabled(enabled, parent) ;
        asEditor.getTextControl(parent).addModifyListener(validator) ;
        
        profileEditor = new ProfileFieldEditor(parent) ;
        addField(profileEditor) ;
        profileEditor.setEnabled(enabled, parent) ;
        profileEditor.getTextControl(parent).addModifyListener(validator) ;
   }
    
    /**
     * Handle a property change event.
     * @param PropertyChangeEvent The property change event.
     */
    public void propertyChange(final PropertyChangeEvent event)
    {
        final Object source = event.getSource() ;
        
        if ((source == esbEditor) && FieldEditor.VALUE.equals(event.getProperty()))
        {
            validateEditors() ;
        }
        
        super.propertyChange(event);
    }
    
    /**
     * Validate the editor.
     */
    private void validateEditors()
    {
       final String newLocation = esbEditor.getStringValue() ;
       final boolean enabled = !ESBUtils.isESBServerLocation(newLocation) ;
       asEditor.setEnabled(enabled, getFieldEditorParent()) ;
       profileEditor.setEnabled(enabled, getFieldEditorParent());
       checkState() ;
    }

    /**
     * Handle the initialisation of the preference page.
     * @param workbench The current workbench.
     */
    public void init(final IWorkbench workbench)
    {
    }
}