/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2007
 */

package org.jboss.soa.esb.eclipse.preferences;

import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.jboss.soa.esb.eclipse.util.ESBUtils;

/**
 * The ESB Directory field editor.
 * 
 * @author kevin
 */
public class ESBDirectoryFieldEditor extends DirectoryFieldEditor
{
    /**
     * Construct the ESB Directory Field Editor.
     * @param parent The parent composite.
     */
    public ESBDirectoryFieldEditor(Composite parent)
    {
        super(ESBPreferenceConstants.ESB_LOCATION, "&ESB Install Location:", parent);
        setEmptyStringAllowed(false) ;
        setErrorMessage("ESB location does not specify an ESB installation");
    }
    
    /**
     * Check the state after a change.
     * @return true if valid, false otherwise.
     */
    protected boolean doCheckState()
    {
        if (super.doCheckState())
        {
            final String esbLocation = getTextControl().getText();
            return (ESBUtils.isESBServerOrESBLocation(esbLocation)) ;
        }
        return false ;
    }
}
