/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.admin.console.transform;

import static org.testng.AssertJUnit.assertEquals;

import java.util.ArrayList;
import java.util.List;

import org.jboss.soa.esb.admin.console.contract.MessageContract;
import org.jboss.soa.esb.admin.console.exchange.MessageExchange;
import org.jboss.soa.esb.admin.console.exchange.participant.Participant;
import org.testng.annotations.Test;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class SmooksUtilsTest {

	/*
	 * Test method for 'org.jboss.soa.esb.admin.console.transform.SmooksUtils.getMessageExchangeConfigs(MessageExchange, List<TransformationResource>)'
	 */
	@Test
	public void test_getMessageExchangeConfigs() {
		MessageExchange flow = new MessageExchange();
		List<TransformationResource> allResources = new ArrayList<TransformationResource>();
		List<TransformationResource> flowResources;
		TransformationResource resource;
		
		resource = new TransformationResource();
		resource.setUseragent(MessageExchange.FROM + "A");
		resource.setSelector("header");
		allResources.add(resource);
		
		resource = new TransformationResource();
		resource.setUseragent(MessageExchange.FROM + "A AND " + MessageExchange.TO + "B");
		resource.setSelector("header");
		allResources.add(resource);
		
		resource = new TransformationResource();
		resource.setUseragent("*");
		resource.setSelector("header");
		allResources.add(resource);
		
		resource = new TransformationResource();
		resource.setUseragent(MessageExchange.FROM + "B");
		resource.setSelector("body");
		allResources.add(resource);
		
		resource = new TransformationResource();
		resource.setUseragent(MessageExchange.FROM + "B AND " + MessageExchange.TO_TYPE + "text/xml");
		resource.setSelector("body");
		allResources.add(resource);
		
		resource = new TransformationResource();
		resource.setUseragent(MessageExchange.FROM + "B AND " + "not:" + MessageExchange.FROM_TYPE + "text/xml");
		resource.setSelector("body");
		allResources.add(resource);
		
		resource = new TransformationResource();
		resource.setUseragent(MessageExchange.FROM + "C");
		resource.setSelector("legs");
		allResources.add(resource);

		// Set the flow and run some tests...
		flow.setFrom(new Participant("A"));
		flowResources = SmooksUtils.getMessageExchangeConfigs(flow, allResources);
		assertEquals(2, flowResources.size());
		assertEquals(allResources.get(0), flowResources.get(0)); // 1st
		assertEquals(allResources.get(2), flowResources.get(1)); // 3rd - useragent="*"

		// Change the flow and run some more tests...
		flow.setFrom(new Participant("A"));
		flow.setTo(new Participant("B"));
		flowResources = SmooksUtils.getMessageExchangeConfigs(flow, allResources);
		assertEquals(3, flowResources.size());
		assertEquals(allResources.get(1), flowResources.get(0)); // 2nd - useragent expression is more specific
		assertEquals(allResources.get(0), flowResources.get(1)); // 1st
		assertEquals(allResources.get(2), flowResources.get(2)); // 3rd - useragent="*"

		flow.reset();
		
		// Change the flow and run some more tests...
		flow.setFrom(new Participant("B"));
		flow.setFromMessageType(new MessageContract("text/xml", null, null));
		flowResources = SmooksUtils.getMessageExchangeConfigs(flow, allResources);
		assertEquals(2, flowResources.size());
		assertEquals(allResources.get(3), flowResources.get(0)); // 4th
		assertEquals(allResources.get(2), flowResources.get(1)); // 3rd - useragent="*"

		// Change the flow and run some more tests...
		flow.setFrom(new Participant("B"));
		flow.setFromMessageType(new MessageContract("text/xml", null, null));
		flow.setToMessageType(new MessageContract("text/xml", null, null));
		flowResources = SmooksUtils.getMessageExchangeConfigs(flow, allResources);
		assertEquals(3, flowResources.size());
		assertEquals(allResources.get(4), flowResources.get(0)); // 5th
		assertEquals(allResources.get(3), flowResources.get(1)); // 4th
		assertEquals(allResources.get(2), flowResources.get(2)); // 3rd - useragent="*"
	}
}
