/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.admin.console.transform;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.validator.NotNull;
import org.jboss.seam.annotations.Name;

/**
 * Transformation Resource Parameter.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
@Entity
@Name("transResourceParameter")
public class TransformationResourceParameter implements Serializable {

	private static final long serialVersionUID = 1L;
	private String id;
	private TransformationResource transResource;
	private String name;
	private String type;
	private String value;

	public TransformationResourceParameter() {
	}

	public TransformationResourceParameter(String name, String type, String value) {
		this.name = name;
		this.type = type;
		setValueAsString(value);
	}

	/**
	 * @return Returns the id.
	 */
	@Id @GeneratedValue(generator="system-uuid")
	@GenericGenerator(name="system-uuid", strategy = "uuid")
	public String getId() {
		return id;
	}

	/**
	 * @param id The id to set.
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return Returns the transResource.
	 */
	@ManyToOne
	public TransformationResource getTransResource() {
		return transResource;
	}

	/**
	 * @param transResource The transResource to set.
	 */
	public void setTransResource(TransformationResource transResource) {
		this.transResource = transResource;
	}
	
	/**
	 * @return Returns the name.
	 */
	@NotNull
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return Returns the valueAsString.
	 */
	@NotNull
	@Transient
	public String getValueAsString() {
		if(value == null) {
			return null;
		}
		return new String(value);
	}
	/**
	 * @param valueAsString The valueAsString to set.
	 */
	public void setValueAsString(String value) {
		this.value = value;
	}

	/**
	 * @return Returns the value.
	 */
	@Lob
	public String getValue() {
		return value;
	}

	/**
	 * @param value The value to set.
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * @return Returns the type.
	 */
	@Column(name="param_type")
	public String getType() {
		return type;
	}

	/**
	 * @param type The type to set.
	 */
	public void setType(String type) {
		this.type = type;
	}
}
