/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.admin.console.transform;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.validator.NotNull;
import org.jboss.seam.annotations.Name;

/**
 * Transformation resource.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
@Entity
@Name("transResource")
public class TransformationResource implements Serializable {

	private static final long serialVersionUID = 1L;
	private String id;
	private String name;
	private String useragent;
	private String selector;
	private String namespace;
	private String path;
	private List<TransformationResourceParameter> parameters;

	/**
	 * @return Returns the id.
	 */
	@Id @GeneratedValue(generator="system-uuid")
	@GenericGenerator(name="system-uuid", strategy = "uuid")
	public String getId() {
		return id;
	}

	/**
	 * @param id The id to set.
	 */
	public void setId(String id) {
		this.id = id;
	}
	
	/**
	 * @return Returns the namespace.
	 */
	public String getNamespace() {
		return namespace;
	}
	/**
	 * @param namespace The namespace to set.
	 */
	public void setNamespace(String namespace) {
		this.namespace = namespace;
	}
	/**
	 * @return Returns the path.
	 */
	public String getPath() {
		return path;
	}
	/**
	 * @param path The path to set.
	 */
	public void setPath(String path) {
		this.path = path;
	}
	/**
	 * @return Returns the parameters.
	 */
	@OneToMany(mappedBy="transResource")
	public List<TransformationResourceParameter> getParameters() {
		return parameters;
	}
	/**
	 * @param parameters The parameters to set.
	 */
	public void setParameters(List<TransformationResourceParameter> parameters) {
		this.parameters = parameters;
	}
	/**
	 * @return Returns the selector.
	 */
	@NotNull
	public String getSelector() {
		return selector;
	}
	/**
	 * @param selector The selector to set.
	 */
	public void setSelector(String selector) {
		this.selector = selector;
	}
	/**
	 * @return Returns the useragent.
	 */
	public String getUseragent() {
		return useragent;
	}
	/**
	 * @param useragent The useragent to set.
	 */
	public void setUseragent(String useragent) {
		this.useragent = useragent;
	}

	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Is the specified parameter configured on the supplied transformation resource configuration. 
	 * @param paramName The parameter to check for.
	 * @param transResource The resource to check.
	 * @return True if the parameter is set, otherwise false.
	 */
	public static boolean isParamaterSet(String paramName, TransformationResource transResource) {
		if(transResource.parameters == null || transResource.parameters.isEmpty()) {
			return false;
		}
		
		for(TransformationResourceParameter param : transResource.getParameters()) {
			if(param.getName().equals(paramName)) {
				return true;
			}
		}

		return false;
	}
}
