/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.admin.console.transform;

import static org.jboss.seam.ScopeType.CONVERSATION;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.EntityManager;

import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.soa.esb.admin.console.SeamUtils;

/**
 * Add Transformation Resource Specification action handler.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
@Name("newResourceSpec")
@Scope(CONVERSATION)
public class NewResourceSpec implements Serializable {

	private static final long serialVersionUID = 1L;

	@In(create=true)
	private EntityManager entityManager;
	
	@In(create=true) @Out
	private TransformationResourceSpec transResourceSpec;
	
	@In(create=true) @Out
	private TransformationResourceParameterSpec transResourceParameterSpec;
	
	@DataModel 
	private List<TransformationResourceParameterSpec> parameterList;
	
	@Begin(join=true)
	public String captureResourceDetailsConfiguration() {
		// Create the new resource and set the useragent...
		transResourceSpec = new TransformationResourceSpec();

		parameterList = new ArrayList<TransformationResourceParameterSpec>();
		transResourceSpec.setParameters(parameterList);
		
		return "new-trans-resource-spec-create";
	}
	
	public String addParameter() {
		if(!parameterList.contains(transResourceParameterSpec)) {
			// Protected against the parameter being added more than once.  I've seen this
			// happen occassionaly.
			parameterList.add(transResourceParameterSpec);
		}
		transResourceParameterSpec = new TransformationResourceParameterSpec();
		
		return "new-trans-resource-spec-create";
	}
	
	public String cancelAddParameter() {
		return "new-trans-resource-spec-create";
	}
	
	@End
	public String save() {
		try {
			// Persist...
			entityManager.persist(transResourceSpec);
			for(TransformationResourceParameterSpec parameter : transResourceSpec.getParameters()) {
				parameter.setResourceSpec(transResourceSpec);
				entityManager.persist(parameter);
			}
			
			return "home";
		} catch(RuntimeException thrown) {
			SeamUtils.printContexts();
			throw thrown;
		}
	}
	
	@End
	public String home() {
		return "home";
	}
}
