/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.admin.console.transform;

import static org.jboss.seam.ScopeType.CONVERSATION;

import java.io.Serializable;
import java.util.List;

import javax.persistence.EntityManager;

import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelectionIndex;

/**
 * Manage <a href="http://milyn.codehaus.org/Smooks">Smooks</a> resource configuration specifications.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
@Name("manageResourceSpecs")
@Scope(CONVERSATION)
public class ManageResourceSpecs implements Serializable {

	private static final long serialVersionUID = 1L;

	@In(create=true)
	private EntityManager entityManager;
	
	@DataModel 
	private List<TransformationResourceSpec> configurationSpecs;
	@DataModelSelectionIndex("configurationSpecs")
	int configurationSpecIndex = 0;
	
	@Begin(join=true)
	public String list() {
		initialise();
		
		return "list-resource-specs";
	}
	
	public String deleteConfiguration() {
		TransformationResourceSpec selectedConfig = configurationSpecs.get(configurationSpecIndex);
		
		for(TransformationResourceParameterSpec parameter : selectedConfig.getParameters()) {
			entityManager.remove(parameter);
		}
		entityManager.remove(selectedConfig);
		initialise();
		
		return "list-resource-spec";
	}

	@End
	public String home() {
		return "home";
	}
	
	/**
	 * Initialise the message exchange configurations list.
	 */
	private void initialise() {
		// Read all resources config specs from the DB...
		configurationSpecs = entityManager.createQuery("from TransformationResourceSpec order by name").getResultList();
	}
}
