/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.admin.console;

import java.util.Arrays;

import org.jboss.seam.contexts.Contexts;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public abstract class SeamUtils {

	public static void printContexts() {
		System.out.println("==================================== Seam Contexts ====================================");
		System.out.println("Appl Ctx [" + Contexts.getApplicationContext() + "]: : " + Arrays.asList(Contexts.getApplicationContext().getNames()));
		System.out.println("Buss Ctx [" + Contexts.getBusinessProcessContext() + "]: : " + Arrays.asList(Contexts.getBusinessProcessContext().getNames()));
		System.out.println("Sess Ctx [" + Contexts.getSessionContext() + "]: " + Arrays.asList(Contexts.getSessionContext().getNames()));
		System.out.println("Conv Ctx [" + Contexts.getConversationContext() + "]: : " + Arrays.asList(Contexts.getConversationContext().getNames()));
		System.out.println("Page Ctx [" + Contexts.getPageContext() + "]: : " + Arrays.asList(Contexts.getPageContext().getNames()));
		System.out.println("Evnt Ctx [" + Contexts.getEventContext() + "]: : " + Arrays.asList(Contexts.getEventContext().getNames()));
		System.out.println("=======================================================================================");
	}
}
