package org.jboss.soa.esb.monitoring.server;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

import org.apache.log4j.Logger;
import org.jboss.soa.esb.actions.AbstractActionLifecycle;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.MessageBodyTypeNames;

/**
 * FilerAction gets the object out of the body of the message and calls the 
 * Filer to store that information.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class FilerAction extends AbstractActionLifecycle {
	  protected ConfigTree  _config;

	  private static final Logger logger = Logger.getLogger(FilerAction.class);
	  public static String INTERNAL_CATEGORY = "JBossESB-Internal";
	  public static String OPERATIONS_COLLECTOR_SERVICE_ACTION_NAME = "OperationsCollectorService";
	  public static String OPERATIONS_FILER_SERVICE_ACTION_NAME = "OperationsFilerService";

	  public static String DATA_COLLECTOR_SERVICE_ACTION_NAME = "DataCollectorService";
	  public static String DATA_FILER_SERVICE_ACTION_NAME = "DataFilerService";
	  
	  public static String INVOKER_SERVICE_ACTION_NAME = "InvokerService";
	  public static String INVOKERFILER_SERVICE_ACTION_NAME = "InvokerFilerService";

	  
	  public FilerAction(ConfigTree config) { _config = config; }

	  /**
	   * The action method which calls the DataFiler to persist the data
	   * stored in the StatisticsData object.
	   * 
	   * @param message message
	   * @return message
	   * @throws Exception
	   */
	  public Message fileMessage(Message message) throws Exception {
		  String commandType = (String) message.getProperties().getProperty(MessageBodyTypeNames.COMMAND_TYPE);
		  if ((message.getProperties() != null) && (commandType != null)) {
			  logger.debug("Filing data...");
			  
			  Filer df = FilerFactory.getInstance().getFiler(commandType);
			  df.setData((Object) message.getBody().get());
			  df.persistData();
		  } else {
			  logger.error("OperationsCollectorAction received a message which was not a command message");
			  message = null;
		  }
		  return null;
	  }
}

