/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.monitoring.pojo;

/**
 * POJO for storage of metadata concerning a JMX attribute.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 * @since Version 4.2
 */
public class JMXAttribute  implements java.io.Serializable {

	private static final long serialVersionUID = 1295239741130189196L;
	private Long id;
	private String objectname;
	private String attribute;

    /**
     * Constructor.
     */
    public JMXAttribute() {
    }

    /**
     * Constructor.
     * @param objectname object name
     * @param attribute attribute name
     */
    public JMXAttribute(String objectname, String attribute) {
       this.objectname = objectname;
       this.attribute = attribute;
    }
   
    /**
     * Id getter.
     * @return id
     */
    public Long getId() {
        return this.id;
    }
    
    /**
     * Id mutator.
     * @param id id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Object name getter.
     * @return object name
     */
    public String getObjectname() {
        return this.objectname;
    }
    
    /**
     * Object name mutator.
     * @param objectname object name
     */
    public void setObjectname(String objectname) {
        this.objectname = objectname;
    }

    /**
     * Attribute name getter.
     * @return attribute name
     */
    public String getAttribute() {
        return this.attribute;
    }
    
    /**
     * Attribute name mutator.
     * @param attribute attribute name
     */
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

}


