/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.monitoring.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.message.body.content.ServiceControlCommand;
import org.jboss.soa.esb.monitoring.MonitoringSessionFactory;
import org.jboss.soa.esb.monitoring.OperationsData;
import org.jboss.soa.esb.monitoring.pojo.JMXPattern;

public class OperationsCollector {

	Logger logger = Logger.getLogger(OperationsCollector.class);
	private Context context;
	private MBeanServerConnection server;
	private OperationsData data;
	
	public OperationsCollector() {
		try {
			context = new InitialContext();
		} catch (NamingException e) {
			logger.error("", e);
		}
                server = MBeanServerLocator.locateJBoss();      
		data = new OperationsData();
	}
	
	public OperationsCollector(Context f_context) {
		context = f_context;
                server = MBeanServerLocator.locateJBoss();      
		data = new OperationsData();

	}
	
	public MBeanServerConnection getServer() {
		return server;
	}
	
	public List getClassPatterns() {
		SessionFactory sf = MonitoringSessionFactory.getInstance();
		
		if (sf != null)
		{
			Session sess = (Session) sf.openSession();
			sess.beginTransaction();
			List result = sess.createQuery("from JMXPattern").list();
			sess.close();
			return result;
		}
		else
		{
			logger.warn("OperationsCollector.getClassPatterns could not get MonitoringSessionFactory instance!");
			
			return null;
		}
	}
	
	public List<ObjectName> getObjectNames(JMXPattern jmc, MBeanServerConnection server) {		
		List<ObjectName> list = new ArrayList<ObjectName>();
		ObjectName namePattern;
		try {
			namePattern = new ObjectName(jmc.getClasspattern());
			Set result = server.queryNames(namePattern, null);
			Iterator iter = result.iterator();
			while (iter.hasNext()) {
				ObjectName on = (ObjectName) iter.next();
				if (on.getKeyPropertyListString().contains(jmc.getKeyvalue())) {
					list.add(on);
					logger.debug(jmc.getKeyvalue() + " matches " + on.getKeyPropertyListString());
				} else {
					logger.debug(jmc.getKeyvalue() + " does not match " + on.getKeyPropertyListString());
				}
			}
		} catch (MalformedObjectNameException e) {
			logger.error("", e);
		} catch (NullPointerException e) {
			logger.error("", e);
		} catch (IOException e) {
			logger.error("", e);
		}
			
		return list;
	}	
	
	public void insertOperations(ObjectName on) {
		String serverString = null; 
		MBeanInfo  info = null;
		Date date = new Date(System.currentTimeMillis());
		InetAddress addr = null;
		try {
			addr = InetAddress.getLocalHost();
			String jndiURLString = (String) context.getEnvironment().get(Context.PROVIDER_URL);
			URL jndiURL = new URL("http://" + jndiURLString);
			serverString = addr.getHostName() + ":" + jndiURL.getPort();
		} catch (UnknownHostException e) {
			logger.error("", e);
		} catch (NamingException e) {
			logger.error("", e);
		} catch (MalformedURLException e) {
			logger.error("", e);
		}
		
		try {
			info = server.getMBeanInfo(on);
			MBeanOperationInfo[] moi = info.getOperations();
			for (int i = 0; i < moi.length; i++) {
				ServiceControlCommand ob = new ServiceControlCommand(on.toString(), serverString, 
						date, moi[i].getName(), moi[i].getDescription(), 
						moi[i].getReturnType());
				if (moi[i].getSignature().length == 0) {
					ArrayList<ServiceControlCommand> list = (ArrayList<ServiceControlCommand>) data.getList();
					list.add(ob);
				}
			}
		} catch (Exception e) {
			logger.error("", e);
		}
	}
	
	public void collectData() {
		List jmxPatterns = getClassPatterns();
		
		if (jmxPatterns != null)
		{
			for (int i = 0; i < jmxPatterns.size(); i++) {
				JMXPattern jmxc = (JMXPattern) jmxPatterns.get(i);
				List<ObjectName> objectNames = getObjectNames(jmxc, server);
				for (int j = 0; j < objectNames.size(); j++) {
					ObjectName on = (ObjectName) objectNames.get(j);
					insertOperations(on);
				}
			}
		}
		else
			logger.debug("OperationsCollector.collectData has no jmxPatterns!");
	}
	
	public OperationsData getData() {
		return data;
	}
	
}
