/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.monitoring;
/*
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

/**
 * MonitoringSessionFactory is a singleton for hibernate's SessionFactory object.    The 
 * monitoring and management app uses a static SessionFactory variable to store
 * the Hibernate SessionFactory.
 * 
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 * @since Version 4.2
 * 
 */
public class MonitoringSessionFactory {
	public static final String HIBERNATE_JNDI = "java:/hibernate/MonitoringSessionFactory";
	private static final Logger m_Logger = Logger.getLogger(MonitoringSessionFactory.class);	
	
	private static SessionFactory sessionFactory;
	
	private MonitoringSessionFactory() {
	}
				
	public static synchronized SessionFactory getInstance() {
		if (sessionFactory == null) {
			init();
		}
		return sessionFactory;
	}
	
	/**
	 * Grab InitialContext out of JNDI.
	 * @param f_cfg hibernate configuration
	 * @throws ConfigurationException
	 */
	private static void init() {
		try {
			sessionFactory = new Configuration().configure("monitoring.cfg.xml").buildSessionFactory();
		} catch (Exception e) {
			m_Logger.error("MonitoringSessionFactory failed to initialize!", e);
		}
	}

}