<%@ page import="java.util.List" %>
<%@ page import="org.jboss.soa.esb.listeners.config.ServicePublisher" %>
<%@ page import="org.jboss.soa.esb.services.registry.RegistryFactory" %>
<%@ page import="org.jboss.soa.esb.services.registry.Registry" %>
<%@ page import="org.jboss.soa.esb.services.registry.RegistryException" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="org.jboss.soa.esb.addressing.EPR" %>
<%@ page import="java.net.URI" %>
<%@ page import="org.jboss.internal.soa.esb.publish.ContractInfo" %>
<%@ page import="org.jboss.soa.esb.actions.soap.WebserviceContractPublisher" %>
<%@ page import="org.jboss.internal.soa.esb.publish.ContractPublisher" %>
<%
    List publishers = ServicePublisher.getServicePublishers();
    Registry registry = RegistryFactory.getRegistry();
    String targetServiceCat = request.getParameter("serviceCat");
    String targetServiceName = request.getParameter("serviceName");
    String targetProtocol = request.getParameter("protocol");
    ContractInfo contractInfo = null;
    String contractData = null;

    for (int i = 0; i < publishers.size() && contractInfo == null; i++) {
        ServicePublisher publisher = (ServicePublisher) publishers.get(i);
        String serviceCategory = publisher.getCategory();
        String serviceName = publisher.getServiceName();
        List eprs;

        if (publisher.getContractPublisher() == null) {
            continue;
        } else if (!serviceCategory.equalsIgnoreCase(targetServiceCat) ||
                !serviceName.equalsIgnoreCase(targetServiceName)) {
            continue;
        }

        try {
            eprs = (List) registry.findEPRs(serviceCategory, serviceName);
        } catch (RegistryException e) {
            // ignore for now - just return an empty list
            eprs = new ArrayList();
        }

        for (int ii = 0; ii < eprs.size(); ii++) {
            EPR epr = (EPR) eprs.get(ii);
            URI eprURI = URI.create(epr.getAddr().getAddress());
            String protocol = eprURI.getScheme();

            if (protocol.equalsIgnoreCase(targetProtocol)) {
                ContractPublisher contractPublisher = publisher.getContractPublisher();

                if(contractPublisher instanceof WebserviceContractPublisher) {
                    contractInfo = ((WebserviceContractPublisher)contractPublisher).getContractInfo(epr, request);
                } else {
                    contractInfo = contractPublisher.getContractInfo(epr);
                }
                break;
            }
        }

        if (contractInfo != null) {
            contractData = contractInfo.getData();
            response.setContentType(contractInfo.getMimeType());
        } else {
            contractData = "<Unavailable/>";
            response.setContentType("text/xml");
        }
    }
%><%=contractData%>