package model.services {
	
	/**
	 * Listener which references a FtpBus.
	 */
	[Bindable]
	public class FtpListener extends Listener {
		
		/** Number of seconds between FTP polls */
		public var pollFrequencySeconds:Number;
		
		/**
		 * Create a FtpListener from XML.
		 */
		public function FtpListener(xml:XML = null) {
			super(xml);
			if (xml != null) {
				this.pollFrequencySeconds = xml.attribute("poll-frequency-seconds");
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		override public function getXmlString():String {
			var xml:String = "<ftp-listener ";
			xml = xml + " name=\"" + this.name + "\" ";
			xml = xml + " busidref=\"" + this.busIdRef + "\" ";
			xml = xml + " maxThreads=\"" + this.maxThreads + "\" ";
			xml = xml + " is-gateway=\"" + this.isGateway + "\" ";
			xml = xml + " poll-frequency-seconds=\"" + this.pollFrequencySeconds + "\" ";
			xml = xml + "/>";
			return xml;
		}
	}
}