package model.services {
	
	import model.common.Property;
	
	import mx.collections.ArrayCollection;
	
	/**
	 * Action performed on messages received by the service.
	 */
	[Bindable]
	public class Action {
		
		/** Action name */
		public var name:String;
		
		/** Class executed by action */
		public var actionClass:String;
		
		/** Function to be executed on actionClass */
		public var processingFunction:String;
		
		/** Action properties */
		public var properties:ArrayCollection;
		
		/**
		 * Create an Action from XML.
		 */
		public function Action(xml:XML = null) {
			if (xml != null) {
				this.name = xml.@name;
				this.actionClass = xml.attribute("class");
				this.processingFunction = xml.@process;
				this.properties = Property.getProperties(xml);
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		public function getXmlString():String {
			var xml:String = "<action ";
			xml = xml + " name=\"" + this.name + "\" ";
			xml = xml + " class=\"" + this.actionClass + "\" ";
			if ((this.processingFunction != null) && (this.processingFunction.length > 0)) {
				xml = xml + " process=\"" + this.processingFunction + "\" ";
			}
			xml = xml + ">";
			for each (var property:Property in properties) {
				xml = xml + property.getXmlString();
			}
			xml = xml + "</action>";
			return xml;
		}
		
		/**
		 * Create a clone of this action.
		 */
		public function clone():Action {
			var action:Action = new Action();
			action.name = this.name;
			action.actionClass = this.actionClass;
			action.processingFunction = this.processingFunction;
			action.properties = Property.cloneProperties(this.properties);
			return action;
		}
		
		/**
		 * Load a list of actions from XML.
		 */
		public static function getActions(xml:XML):ArrayCollection {
			var results:ArrayCollection = new ArrayCollection();
			for each (var actionXml:XML in xml.children()) {
				results.addItem(new Action(actionXml));					
			}
			return results;
		}
	}
}