package model.providers {
	
	import model.common.Property;
	
	import mx.collections.ArrayCollection;
	
	/**
	 * Specifies a data provider for getting information onto a bus.
	 */
	[Bindable]
	public class Provider {
		
		/** Provider name */
		public var name:String;
		
		/** Collection of provider props */
		public var properties:ArrayCollection = new ArrayCollection();
		
		/** Collection of buses */
		public var buses:ArrayCollection = new ArrayCollection();
		
		/**
		 * Create a provider from XML.
		 */
		public function Provider(xml:XML = null) {
			if (xml != null) {
				this.name = xml.@name;
				this.properties = Property.getProperties(xml);
				this.buses = Bus.getBuses(xml);
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		public function getXmlString():String {
			return null;
		}
		
		/**
		 * Load a list of providers from XML.
		 */
		public static function getProviders(xml:XML):ArrayCollection {
			var results:ArrayCollection = new ArrayCollection();
			for each (var providerXml:XML in xml.children()) {
				var tag:String = providerXml.localName();
				if (tag == "fs-provider") {
					results.addItem(new FileProvider(providerXml));					
				} else if (tag == "ftp-provider") {
					results.addItem(new FtpProvider(providerXml));					
				} else if (tag == "jms-provider") {
					results.addItem(new JmsProvider(providerXml));					
				}
			}
			return results;
		}
	}
}