package model.providers {
	
	/**
	 * Message filter for an FtpBus
	 */
	[Bindable]
	public class JmsMessageFilter {
		
		/** Destination name */
		public var destName:String;
		
		/** Destination type */
		public var destType:String;
		
		/** Selector */
		public var selector:String;
		
		/** Constant for queue dest type */
		public static const QUEUE:String = "QUEUE";
		
		/** Constant for topic dest type */
		public static const TOPIC:String = "TOPIC";
		
		/**
		 * Create a FileMessageFilter from XML.
		 */
		public function JmsMessageFilter(xml:XML = null) {
			if (xml != null) {
				this.destName = xml.attribute("dest-name");
				this.destType = xml.attribute("dest-type");
				this.selector = xml.attribute("selector");
			}
		}
		
		/**
		 * Get the XML representation.
		 */
		public function getXmlString():String {
			var xml:String = "<jms-message-filter ";
			xml = xml + " dest-name=\"" + this.destName + "\" ";
			xml = xml + " dest-type=\"" + this.destType + "\" ";
			if (this.selector.length > 0) {
				xml = xml + " selector=\"" + this.selector + "\" ";
			}
			xml = xml + "/>";
			return xml;
		}
	}
}