package model.common {
	
	import mx.collections.ArrayCollection;
	
	/**
	 * A name-value pair.
	 */
	[Bindable]
	public class Property {
		
		/** Property name */
		public var name:String;
		
		/** Property value */
		public var value:String;
		
		/** Nested elements */
		public var nested:String;
		
		/** QName for the providers element */
		private static const PROPERTY:QName = new QName(Namespaces.JESB, "property");
		
		/**
		 * Create a Property from XML.
		 */
		public function Property(xml:XML = null) {
			if (xml != null) {
				this.name = xml.@name;
				this.value = xml.@value;
				this.nested = xml.children().toXMLString();
			}
		}
		
		/**
		 * Convenience method for existence of nested content.
		 */
		public function get hasNested():Boolean {
			return ((this.nested != null) && (this.nested.length > 0));
		}
		
		/**
		 * Get the XML representation.
		 */
		public function getXmlString():String {
			var xml:String = "<property ";
			xml = xml + " name=\"" + this.name + "\" ";
			xml = xml + " value=\"" + this.value + "\" ";
			xml = xml + ">";
			if ((this.nested != null) && (this.nested.length > 0)) {
				xml = xml + this.nested;
			}
			xml = xml + "</property>";
			return xml;
		}
		
		/**
		 * Create a clone of this property.
		 */
		public function clone():Property {
			var result:Property = new Property();
			result.name = this.name;
			result.value = this.value;
			result.nested = this.nested;
			return result;
		}
		
		/**
		 * Clone a list of properties.
		 */
		public static function cloneProperties(original:ArrayCollection):ArrayCollection {
			var result:ArrayCollection = new ArrayCollection();
			for each (var prop:Property in original) {
				result.addItem(prop.clone());
			}
			return result;
		}
		
		/**
		 * Get a list of properties from an enclosing element.
		 */
		public static function getProperties(xml:XML):ArrayCollection {
			var result:ArrayCollection = new ArrayCollection();
			for each (var propXml:XML in xml.elements(PROPERTY)) {
				var prop:Property = new Property(propXml);
				result.addItem(prop);
			}
			return result;
		}
	}
}