package model {
	
	import model.providers.Bus;
	import model.providers.Provider;
	import model.services.Action;
	import model.services.ActionTemplateManager;
	import model.services.Listener;
	import model.services.Service;
	import mx.collections.ArrayCollection;
	import mx.controls.Alert;
	
	/**
	 * The model that holds information about the loaded configuration.
	 */
	[Bindable]
	public class JBossESBModel {
		
		/** Configuration model loaded from XML */
		private var _config:JBossESB = new JBossESB();
		
		/** Configuration file name */
		public var selectedConfigName:String;

		/** Base URL for server calls */
		public var serverBaseUrl:String = "http://localhost:8080/";
		
		/** List of action templates */
		public var actionTemplates:ArrayCollection = new ArrayCollection();
		
		/** Currently selected provider */
		public var selectedProvider:Provider;
		
		/** Currently selected bus */
		public var selectedBus:Bus;
		
		/** Currently selected service */
		public var selectedService:Service;
		
		/** Currently selected listener */
		public var selectedListener:Listener;
		
		/** Currently selected action */
		public var selectedAction:Action;
		
		/** List of available configs on the server */
		public var configsList:ArrayCollection = new ArrayCollection();
		
		/**
		 * Setter for the working configuration.
		 */
		public function set config(config:JBossESB):void {
			this._config = config;
			this.selectedProvider = null;
			this.selectedService = null;
			this.selectedBus = null;
			this.selectedAction = null;
			this.selectedListener = null;
		}
		
		/**
		 * Getter for the working configuration.
		 */
		public function get config():JBossESB {
			return this._config;
		}
			
		/**
		 * Save the working configuration as XML.
		 */
		public function getConfigAsXml():XML {
			return config.getXml();
		}
		
		/**
		 * Load the working configuration from XML.
		 */
		public function setConfigFromXml(xml:XML):void {
			try {
				var startTag:String = xml.localName();
				if ((startTag != null) || (startTag == "jbossesb")) {
					var newConfig:JBossESB = new JBossESB(xml);
					config = newConfig;
				} else {
					Alert.show("JBossESB Configuration Invalid", "Error");
				}
			} catch (err:Error) {
				Alert.show(err.message, "Error Parsing Configuration");
			}
		}
	}
}