package org.jboss.configapp;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UploadServlet extends HttpServlet {

	/** Serial version UID */
	private static final long serialVersionUID = 1L;

	/** Size of read buffer in bytes */
	private static final int BUFFER_SIZE = 1024;

	/** Default configuration file */
	private static final String DEFAULT_CONFIG = "jboss-esb.xml";

	@SuppressWarnings("unchecked")
	@Override
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		// Use parameter to choose file to load.
		String uri = request.getRequestURI();
		String fileParam = uri.substring(uri.lastIndexOf('/') + 1);
		if ((fileParam == null) || (fileParam.length() == 0)) {
			fileParam = DEFAULT_CONFIG;
		}
		File esbConfig = JBossESBConfigLocator.getConfigFileByName(fileParam);
		OutputStream output = JBossESBConfigLocator
				.getConfigXmlOutputStream(esbConfig);

		if (output == null) {
			throw new ServletException(
					"Unable to find config XML to overwrite: "
							+ esbConfig.getName());
		}

		DataInputStream input = null;
		try {
			byte[] bbuf = new byte[BUFFER_SIZE];
			input = new DataInputStream(request.getInputStream());

			int length = 0;
			while ((input != null) && ((length = input.read(bbuf)) != -1)) {
				output.write(bbuf, 0, length);
			}
		} finally {
			try {
				if (input != null) {
					input.close();
				}
				if (output != null) {
					output.close();
				}
			} catch (IOException e) {
			}
		}
	}
}