/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.jbpm.cmd;

import java.util.Map;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.services.jbpm.Constants;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

/**
 * @author kstam
 *
 */
public class CallbackCommand implements Command {

    private static Logger logger = Logger.getLogger(CallbackCommand.class);
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    
    /**
     * The named transition or null if the default is to be used.
     */
    private String transitionName ;
    /**
     * The variable map.
     */
    private Map variables ;
    
    private EPR callbackEpr;
    
    public CallbackCommand() {
        super();
    }
    
    public EPR getCallbackEpr() {
        return callbackEpr;
    }
    public void setCallbackEpr(EPR callbackEpr) {
        this.callbackEpr = callbackEpr;
    }
    
    public void setTransitionName(final String transitionName) {
        this.transitionName = transitionName ;
    }
    
    public void setVariables(final Map variables) {
        this.variables = variables ;
    }
    
    public Object execute(JbpmContext jbpmContext) 
    {
        final boolean isDebugEnabled = logger.isDebugEnabled() ;
        try {
            long nodeId  = Long.parseLong(callbackEpr.getAddr().getExtensionValue(Constants.NODE_ID));
            long tokenId = Long.parseLong(callbackEpr.getAddr().getExtensionValue(Constants.TOKEN_ID));
            long processInstanceId = Long.parseLong(callbackEpr.getAddr().getExtensionValue(Constants.PROCESS_INSTANCE_ID));
            String counterName = Constants.PROCESS_NODE_VERSION_COUNTER + nodeId + '_' + tokenId;
            long processNodeVersion = Long.parseLong(callbackEpr.getAddr().getExtensionValue(counterName));
            if (isDebugEnabled) logger.debug("Expected nodeId=" + nodeId + 
                    ", tokenId=" + tokenId + ", processNodeVersion=" + processNodeVersion);
            //get update on current state of things.
            final Token token = jbpmContext.getToken(tokenId) ;
            if (token == null) {
                throw new CallbackException("Token id " + tokenId + " from process instance " + processInstanceId + " is no longer active") ;
            }
            final ProcessInstance instance = token.getProcessInstance() ;
            if (instance == null) {
                throw new CallbackException("Process instance " + processInstanceId + " is no longer active") ;
            }
            if (instance.getId() != processInstanceId) {
                throw new CallbackException("Token id " + tokenId + " from process instance " + processInstanceId + " now attached to process instance " + instance.getId()) ;
            }
            
            if (nodeId != token.getNode().getId()) {
                throw new CallbackException("Token id " + tokenId + " from process instance " + processInstanceId + " is no longer on expected node, expected " + nodeId + " but discovered " + token.getNode().getId()) ;
            }
            if (token.hasEnded()) {
                throw new CallbackException("Token id " + tokenId + " from process instance " + processInstanceId + " has already terminated") ;
            }
            
            if (token.isLocked()) {
                throw new CallbackException("Token id " + tokenId + " from process instance " + processInstanceId + " is already locked, another thread is active") ;
            }
            
            final ContextInstance contextInstance = instance.getContextInstance() ;
            final long currentProcessNodeVersion = Long.parseLong(String.valueOf(
                    contextInstance.getVariableLocally(counterName, token)));
            if (isDebugEnabled) logger.debug("ProcessNodeVersion=" + currentProcessNodeVersion);
            if (processNodeVersion!=currentProcessNodeVersion) {
                throw new CallbackException("The current processNodeVersion (id=" + currentProcessNodeVersion +
                        ") is not the expected version (version=" + processNodeVersion + ").");
            }
            
            AsyncProcessSignal.createSignalJob(jbpmContext, token, transitionName, jbpmContext.getActorId(), variables) ;
        } catch (CallbackException jbpmCe) {
            logger.warn(jbpmCe.getMessage());
        }
        return null;
    }
}
