/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author daniel.brum@jboss.com
 */

package org.jboss.soa.esb.messagestore;

import java.net.URI;
import java.util.Random;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.persistence.format.MessageStoreFactory;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;
import org.jboss.soa.esb.services.persistence.MessageStore;

/**
 * @author dbrum
 * 
 */
public class MessageStoreClient implements Runnable
{

	private static Logger logger = Logger.getLogger(MessageStoreUnitTest.class);

	public void run ()
	{
		long startTime = System.currentTimeMillis();

		int requestors = 1000; // number of persist calls to make
		Vector<URI> writeList = new Vector<URI>();

		// get the database store
		MessageStore store = MessageStoreFactory.getInstance().getMessageStore();

		// messages to persist
		Message msg[] = { MessageFactory.getInstance().getMessage(
				MessageType.JBOSS_XML), MessageFactory.getInstance()
				.getMessage(MessageType.JAVA_SERIALIZED) };

		// set some content inside the Messages
		for (int x = 0; x < msg.length; x++)
		{
			msg[x].getBody().add("TEST BODY".getBytes());
			msg[x].getProperties().setProperty("prop" + x, "val" + x);
			msg[x].getAttachment().addItem(new String("TEST ATTACHMENT"));
		}

		// loop through adding the messages

		Random rndMsg = new Random();
		for (int x = 0; x <= requestors; x++)
		{
			try
			{
				URI uid = store.addMessage(msg[rndMsg.nextInt(2)], MessageStore.CLASSIFICATION_DEFAULT);
				if (uid != null) writeList.add(uid);
				else
					System.err
							.println("null was found... not adding uid to list...");
			}
			catch (Exception ex)
			{
				logger.error("Adding message failed.", ex);
			}
		}

		logger
				.info("total messages persisted to db: " + (writeList.size() - 1));

		// loop back reading the messages from the db
		Vector<Message> readList = new Vector<Message>();
		for (int x = 0; x < writeList.size(); x++)
		{
			try
			{
				readList.add(store.getMessage(writeList.get(x)));
			}
			catch (Exception e)
			{
				logger.error(e);
			}
		}
		logger.info("total messages read from db: " + (readList.size() - 1));
		logger.info("time to finish write/read for this client: " + (System
				.currentTimeMillis() - startTime) + " milliseconds.");

	}
}
