/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */
package org.jboss.soa.esb.samples.quickstart.webservice_consumer2;

import java.util.ArrayList;
import java.util.HashMap;

import org.jboss.soa.esb.actions.AbstractActionLifecycle;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;

public class MyRequestAction extends AbstractActionLifecycle
{
   protected ConfigTree _config;

   public MyRequestAction(ConfigTree config)
   {
      _config = config;
   }

   public Message noOperation(Message message)
   {
      return message;
   }
   
   /*
    * Convert the message into a webservice request map.
    */
   public Message option1(Message message) throws Exception
   {
      logHeader();
      System.out.println("Webservice Option 1 Request Action\n");
      String msgBody = (String) message.getBody().get();
      HashMap requestMap = new HashMap();
      Order order = new Order();
      order.setId((long)1);
      
      LineItem lineItem1 = new LineItem();
      lineItem1.setId((long)1);
      lineItem1.setName("aname");
      lineItem1.setPrice((float)10.00);
      
      LineItem lineItem2 = new LineItem();
      lineItem2.setId((long)2);
      lineItem2.setName("aname2");
      lineItem2.setPrice((float)20.00);
      
      ArrayList lineItems = new ArrayList();
      lineItems.add(lineItem1);
      lineItems.add(lineItem2);
      
      order.setLineItems(lineItems);
      
      ProcessOrderRequest requestObject = new ProcessOrderRequest();
      requestObject.setOrder(order);
      requestMap.put("processOrder", requestObject);
      //requestMap.put("order", order);
      
      message.getBody().add(requestMap);
      System.out.println("Request map is: " + requestMap.toString());

      logFooter();
      return message;
   }
   
   /*
    * Convert the message into a webservice request map.
    */
   public Message option2(Message message) throws Exception
   {
      logHeader();
      System.out.println("Webservice Option 2 Request Action\n");
      String msgBody = (String) message.getBody().get();
      HashMap requestMap = new HashMap();
          
      // add paramaters to the web service request map
      requestMap.put("processOrder.order.id", "1");
      requestMap.put("processOrder.order.shipTo", "1234 my way");
      
      requestMap.put("processOrder.order.lineItems[0].id", "1");      
      requestMap.put("processOrder.order.lineItems[0].name", "item name b");
      requestMap.put("processOrder.order.lineItems[0].price", "20.00");
      requestMap.put("processOrder.order.lineItems[1].id", "2");
      requestMap.put("processOrder.order.lineItems[1].name", "item name c");
      requestMap.put("processOrder.order.lineItems[1].price", "30.00");
      
      // The "paramsLocation" property was set in jboss-esb.xml to
      message.getBody().add(requestMap);
      System.out.println("Request map is: " + requestMap.toString());

      logFooter();
      return message;
   }
   
    public void exceptionHandler(Message message, Throwable exception)
   {
      logHeader();
      exception.printStackTrace();
      System.out.println("!ERROR!");
      System.out.println(exception.getMessage());
      System.out.println("For Message: ");
      System.out.println(message.getBody().get());
      logFooter();
   }

   // This makes it easier to read on the console
   private void logHeader()
   {
      System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\n");
   }

   private void logFooter()
   {
      System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\n");
   }

}