/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */
package org.jboss.soa.esb.samples.quickstart.notifications.test;

import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSubscriber;
import javax.jms.TopicSession;
import javax.jms.TextMessage;
import javax.jms.JMSException;
import javax.naming.InitialContext;

import org.jboss.soa.esb.samples.quickstart.notifications.test.TextListener;

public class ReceiveJMSMessageFromTopic {

    TopicConnectionFactory tcf = null;
    TopicConnection conn = null;    
    TopicSession session = null;    
    Topic topic = null;     
    TopicSubscriber subscriber = null;
    InitialContext iniCtx = null;
    String topicName = "topic/D"; // Default to topic/D
    TextListener listener = null ;

    private boolean initialised ;

    public ReceiveJMSMessageFromTopic() {
                   
    }

    private void initialise()
    {
	try {
	    // lookup the TopicConnectionFactory
	    if (iniCtx == null) iniCtx = new InitialContext();
	    if (tcf == null) tcf = (TopicConnectionFactory) iniCtx.lookup("ConnectionFactory");

	    // create and start a connection to JMS suitable for interacting with topics
	    if (conn == null) {
		conn = tcf.createTopicConnection();
		// conn.start();
	    }             

	    // look up the Topic we want to subscribe to and create a TopicSession
	    // for that topic
	    topic = (Topic) iniCtx.lookup(topicName);
	    session = conn.createTopicSession(false, TopicSession.AUTO_ACKNOWLEDGE);

	    // create a TopicSubscriber to the Topic within the TopicSession
	    subscriber = session.createSubscriber(topic);

	    initialised = true ;
	    System.out.println("Initialised") ;
	} catch (final Exception ex) {
	    cleanup() ;
	}
    }
           
    public void cleanup() {
	subscriber = null ;
	session = null ;
	topic = null ;
	try {
	    conn.stop() ;
	} catch (final Exception ex) {
	    // Do nothing ;
	}
	conn = null ;
	tcf = null ;
	iniCtx = null ;
	initialised = false ;
    }
           
    public static void main(String[] args) {

	// create an instance of our helper object
	final ReceiveJMSMessageFromTopic topicHelper = new ReceiveJMSMessageFromTopic();
                      
	if ((args.length > 0) && (args[0] != null)) {
	    topicHelper.topicName = args[0];
	    System.out.println("Receiving on: " + topicHelper.topicName );                     
	}                   
	Runtime.getRuntime().addShutdownHook(new Thread() {
		public void run() {
		    topicHelper.cleanup() ;
		}
	    }) ;

	// init the helper object
	topicHelper.initialise() ;

	try {
	    // set a TextListener to process pubnlished messages asynchronously
	    topicHelper.listener = new TextListener() ;
	    topicHelper.subscriber.setMessageListener(topicHelper.listener) ;

	    // make the connection active 
	    topicHelper.conn.start() ;
	    
	    // TextListener will now pull messages ad infinitum
	    // shutdown hook will be called at Ctrl-C

            // Fix for: http://jira.jboss.com/jira/browse/SOA-456
            while (true) { // loop until I'm killed
                try {
                    Thread.sleep(500);
                } catch (InterruptedException e) {break;}
            } 

	}
	catch(JMSException e) {
	    System.out.println("Exception occurred: " + e.toString()) ;
	    
	}
    }
}

