package org.jboss.soa.esb.testutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import org.apache.log4j.Logger;

public class TestEnvironmentUtil 
{
	private static Logger log = Logger.getLogger(TestEnvironmentUtil.class);
	
	public static String getUserDir()
	{
		return getUserDir("product");
	}
	
	public static String getBaseDir()
	{
		return System.getProperty("user.dir");
	}
	
	/**
	 * When performing file system interaction, the user.dir may differ (i.e. running the
	 * tests from within eclipse).
	 */
	public static String getUserDir(String dir)
	{
		String userDir="";
		String baseDir = System.getProperty("user.dir");
		log.debug(baseDir);
		if (!baseDir.endsWith(dir)) {
			userDir = dir + "/";
		}
		return userDir;
	}
	
	/**
	 * When performing file system interaction, the user.dir may differ (i.e. running the
	 * tests from within eclipse).
	 */
	public static String getUserDir(String eclipseDir, String antDir)
	{
		String userDir="";
		String baseDir = System.getProperty("user.dir");
		log.debug(baseDir);
		if (!baseDir.endsWith(eclipseDir)) {
			if (baseDir.endsWith("qa")) {
				userDir = antDir + "/";
			} else {
				userDir = eclipseDir + "/";
			}
		} else {
			userDir = antDir + "/";
		}
		log.debug(userDir);
		return userDir;
	}
	
	public static void setESBPropertiesFileToUse()
	{
		//Set the jbossesb properties file in System, so we can pick up the one for testing
		String jbossesbPropertiesFile = getUserDir() + "/etc/test/resources/jbossesb-unittest-properties.xml";
		System.setProperty("org.jboss.soa.esb.propertyFile", jbossesbPropertiesFile);
	}
	/**
	 * Sets the jbossesb-properties.xml to use for test
	 */
	public static void setESBPropertiesFileToUse(String dir)
	{
		//Set the jbossesb properties file in System, so we can pick up the one for testing
		String jbossesbPropertiesFile = getUserDir(dir) + "/etc/test/resources/jbossesb-unittest-properties.xml";
		System.setProperty("org.jboss.soa.esb.propertyFile", jbossesbPropertiesFile);
	}
	
	/**
	 * Sets the jbossesb-properties.xml to use for test
	 */
	public static void setESBPropertiesFileToUse(String eclipseDir, String antDir)
	{
		//Set the jbossesb properties file in System, so we can pick up the one for testing
		String jbossesbPropertiesFile = getUserDir(eclipseDir, antDir) + "/etc/test/resources/jbossesb-unittest-properties.xml";
		System.setProperty("org.jboss.soa.esb.propertyFile", jbossesbPropertiesFile);
	}
	
	public static String readTextFile(File file) throws IOException 
    {
        StringBuffer sb = new StringBuffer(1024);
        BufferedReader reader = new BufferedReader(new FileReader(file.getPath()));
        char[] chars = new char[1];
        while( (reader.read(chars)) > -1){
            sb.append(String.valueOf(chars)); 
            chars = new char[1];
        }
        reader.close();
        return sb.toString();
    }
    
    public static File findResourceDirectory(String dirPath)
    {
        String[] dirs = dirPath.split("/");
        for (int i=1; i<dirs.length; i++) {
            dirPath = ".";
            for (int j=i; j<dirs.length; j++) {
                dirPath += "/" + dirs[j];
            }
            File dir = new File(dirPath);
            if (dir.exists()) {
                return dir;
            }
        }
        return null;
    }
	
}
