/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.notification;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;

/**
 * NotificationList unit tests.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class NotificationListUnitTest extends TestCase {

	public void test_NotificationList() throws Exception {
		ConfigTree domEl = ConfigTree.fromInputStream(getClass().getResourceAsStream("NotificationListUnitTest_testfile1.xml"));
		NotificationList nList = new NotificationList(domEl);
		
		List<String> messageList = new ArrayList<String>();
		TestNotificationTarget1.messageList = messageList; 
		TestNotificationTarget2.messageList = messageList;
		
        Message message = MessageFactory.getInstance().getMessage(MessageType.JBOSS_XML);
        message.getBody().add("tom".getBytes());
		nList.sendNotification(message);
		assertEquals(4, messageList.size());
		assertEquals("message 1-tom", messageList.get(0));
		assertEquals("message 2-tom", messageList.get(1));
		assertEquals("message 3-tom", messageList.get(2));
		assertEquals("message 4-tom", messageList.get(3));
	}
	
	public void test_assertionMethods() throws Exception {
		ConfigTree domEl;
		NotificationList nList;
		
		domEl = new ConfigTree("notif");
		nList = new NotificationList(domEl);
		assertTrue(nList.isOK());
		assertTrue(nList.isErr());
		// REVIEW: Is this behavior OK??  Can be OK and Err at the same time!!
		
		domEl = new ConfigTree("notif");
		domEl.setAttribute(NotificationList.TYPE, "ok");
		nList = new NotificationList(domEl);
		assertTrue(nList.isOK());
		assertTrue(!nList.isErr());

		domEl = new ConfigTree("notif");
		domEl.setAttribute(NotificationList.TYPE, "err");
		nList = new NotificationList(domEl);
		assertTrue(!nList.isOK());
		assertTrue(nList.isErr());
	}
}
