/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.message.properties;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;

import org.jboss.soa.esb.addressing.eprs.HTTPEpr;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;

import junit.framework.TestCase;

/**
 * Unit test for MessagePropertyFacade.
 * 
 * @author Tom Cunningham
 */
public class MessagePropertyFacadeUnitTest extends TestCase {
	
	private static final String TEST_STRING = "test0123456";
	
	public void testFacade() {
		Message msg1 = MessageFactory.getInstance().getMessage(MessageType.JAVA_SERIALIZED);
		msg1.getBody().add("foo", "bar");
		try {
			msg1.getHeader().getCall().setTo(new HTTPEpr("http://foo.bar"));
			msg1.getHeader().getCall().setMessageID(new URI("urn:1234"));
		} catch (URISyntaxException e1) {
			e1.printStackTrace();
			fail(e1.getMessage());
		}
		
		/* Test the message id */
		MessagePropertyFacade mpf = new MessagePropertyFacade(msg1);
		assertEquals(msg1.getProperties().getProperty(MessagePropertyFacade.MESSAGE_ID),
				mpf.getMessageCategory());
		mpf.setMessageId(TEST_STRING);
		assertEquals(mpf.getMessageId(), TEST_STRING);
		assertEquals(msg1.getProperties().getProperty(MessagePropertyFacade.MESSAGE_ID),
				TEST_STRING);
		
		/* Test the message category */
		assertEquals(msg1.getProperties().getProperty(MessagePropertyFacade.MESSAGE_CATEGORY),
				mpf.getMessageCategory());
		mpf.setMessageCategory(TEST_STRING);
		assertEquals(mpf.getMessageCategory(), TEST_STRING);
		assertEquals(msg1.getProperties().getProperty(MessagePropertyFacade.MESSAGE_CATEGORY),
				TEST_STRING);

		/* Test the delivery property */
		msg1.getProperties().setProperty(MessagePropertyFacade.MESSAGE_DELIVERED, new Boolean(false));
		Boolean delivery = (Boolean)msg1.getProperties().getProperty(MessagePropertyFacade.MESSAGE_DELIVERED);
		assertEquals(delivery.booleanValue(), mpf.wasDelivered().booleanValue());
		mpf.setDelivered(true);
		assertEquals(mpf.wasDelivered().booleanValue(), true);
		delivery = (Boolean) msg1.getProperties().getProperty(MessagePropertyFacade.MESSAGE_DELIVERED);
		assertEquals(delivery.booleanValue(), true);
		
		/* Test the created date */
		assertEquals(msg1.getProperties().getProperty(MessagePropertyFacade.MESSAGE_CREATED_DATE),
				mpf.getCreatedDate());
		Calendar cDate = Calendar.getInstance();
		mpf.setCreatedDate(cDate);
		assertEquals(mpf.getCreatedDate(), cDate);
		assertEquals(msg1.getProperties().getProperty(MessagePropertyFacade.MESSAGE_CREATED_DATE),
				cDate);
	}
}
