/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.message.mapping;

import java.net.URISyntaxException;

import junit.framework.TestCase;

import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.eprs.FileEpr;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;


/**
 * @author kstam
 *
 */
public class ToMessageMapperUnitTest extends TestCase {

    public void testHeader() throws URISyntaxException, ObjectMappingException
    {
        EPR toEpr = new FileEpr("test1");
        Message message = MessageFactory.getInstance().getMessage();
        
        String expression="header.call.to";
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setObjectOnMessage(message, expression, toEpr);
        
        assertEquals(message.getHeader().getCall().getTo(),toEpr);
        
        final Message message2 = MessageFactory.getInstance().getMessage();
        
        final String expression2="'header'.'call'.to";
        objectMapper.setObjectOnMessage(message2, expression2, toEpr);
        
        assertEquals(toEpr, message2.getHeader().getCall().getTo());
        
    }
    
    public void testBody() throws ObjectMappingException
    {
        TestPojo pojo1 = new TestPojo();
        pojo1.setName("pojo1");
        
        Message message = MessageFactory.getInstance().getMessage();
        
        String expression="body.pojo1Name";
        
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setObjectOnMessage(message, expression, pojo1);
        
        assertEquals(message.getBody().get("pojo1Name"),pojo1);
        
        final Message message2 = MessageFactory.getInstance().getMessage();
        
        final String expression2="'body'.'pojo1Name'";
        
        objectMapper.setObjectOnMessage(message2, expression2, pojo1);
        
        assertEquals(message2.getBody().get("pojo1Name"),pojo1);
        
        final Message message3 = MessageFactory.getInstance().getMessage();
        
        final String expression3="'body'.'pojo3Name'.message";
        final BodyTestObject bodyTestObject = new BodyTestObject() ;
        
        assertNull("Initial body test object message", bodyTestObject.getMessage()) ;
        
        message3.getBody().add("pojo3Name", bodyTestObject) ;
        final String testObjectMessage = "Set message" ;
        objectMapper.setObjectOnMessage(message3, expression3, testObjectMessage);
        
        final BodyTestObject currentBodyTestObject = (BodyTestObject)message3.getBody().get("pojo3Name") ;
        assertNotNull("Retrieve body test object", currentBodyTestObject) ;
        assertEquals("Message set", testObjectMessage, currentBodyTestObject.getMessage()) ;
        
        try
        {
            objectMapper.setObjectOnMessage(message3, "body.DOES_NOT_EXIST.param", "test message") ;
            fail("Expected ObjectMappingException") ;
        }
        catch (final ObjectMappingException ome) {} // expected
    }
    
    public static final class BodyTestObject
    {
        private String message ;
        
        public String getMessage()
        {
            return message ;
        }
        
        public void setMessage(final String message)
        {
            this.message = message ;
        }
    }
}
