/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.message.helper.content;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

import junit.framework.TestCase;

import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.body.content.MapBody;
import org.jboss.soa.esb.message.body.content.ObjectBody;
import org.jboss.soa.esb.message.body.content.TextBody;

/**
 * Unit tests for the Payload class.
 * 
 * @author Mark Little
 */

public class SerializedContentManagerUnitTest extends TestCase
{
	public void testTextMessage () throws Exception
	{
		Message msg = _factory.createTextMessage("hello world");		
		TextBody body = (TextBody) msg.getBody();
		
		assertEquals(body.getText(), "hello world");
	}
	
	public void testObjectMessage () throws Exception
	{
		Message msg = _factory.createObjectMessage("hello world");
		ObjectBody body = (ObjectBody) msg.getBody();
		
		assertEquals(body.getObject(), "hello world");		
	}
	
	public void testMapMessage () throws Exception
	{
		Hashtable<String, Serializable> initial = new Hashtable<String, Serializable>();
		
		initial.put("foo", "bar");
		
		Message msg = _factory.createMapMessage(initial);
		MapBody body = (MapBody) msg.getBody();
		
		assertEquals(body.getString("foo"), "bar");
	}
	
	public void testBytesMessage () throws Exception
	{
		ByteArrayOutputStream stream = new ByteArrayOutputStream();
		ObjectOutputStream output = new ObjectOutputStream(stream);
		
		output.writeInt(12345);
		output.writeUTF("Hello World");
		
		output.flush();
		output.close();
		
		ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(stream.toByteArray()));
		
		assertEquals(input.readInt(), 12345);
		assertEquals(input.readUTF(), "Hello World");
		
		Message msg = _factory.createBytesMessage(stream.toByteArray());
		BytesBody body = (BytesBody) msg.getBody();
		
		body.readMode();
		
		assertEquals(body.readInt(), 12345);
		assertEquals(body.readUTFString(), "Hello World");
	}
	
	private static final SerializedMessageFactory _factory = new SerializedMessageFactory();
}
