/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.listeners.gateway;

import java.io.File;

import org.jboss.internal.soa.esb.couriers.MockCourier;
import org.jboss.internal.soa.esb.couriers.MockCourierFactory;
import org.jboss.internal.soa.esb.services.registry.MockRegistry;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.common.tests.BaseTest;
import org.jboss.soa.esb.helpers.ConfigTree;

public class RemoteGatewayListenerIntegrationTest extends BaseTest
{

    protected void setUp() throws Exception {
        MockCourierFactory.install();
        MockRegistry.install();
        MockRegistry.register("Example", "Test", new MockCourier(true));
    }

    protected void tearDown() throws Exception {
        MockRegistry.uninstall();
        MockCourierFactory.uninstall();
    }

    public RemoteGatewayListenerIntegrationTest ()
	{
	}

	public void testGateway () throws Exception
	{
		ConfigTree tree = new ConfigTree("test");
		final File tmpDir = new File(System.getProperty("user.dir")) ;
		final String tmpDirForm = tmpDir.toURL().toExternalForm() ;

		tree.setAttribute("inputDir", tmpDirForm);
		tree.setAttribute("target-service-category", "Example");
		tree.setAttribute("target-service-name", "Test");
		tree.setAttribute("gatewayClass", "org.jboss.soa.esb.listeners.gateway.RemoteGatewayListener");
		tree.setAttribute("inputSuffix", ".dummy");
		tree.setAttribute("workSuffix", "work");
		tree.setAttribute("postDelete", "true");
		tree.setAttribute("protocol", "ftp");
		
		String url = null;
		
		if (getFtpUser() != null)
			url = getFtpUser()+":";
		
		if (getFtpPwd() != null)
			url = url + getFtpPwd()+"@";

		tree.setAttribute(FTPEpr.URL_TAG, "ftp://"+url+getFtpHostname()+"/"+getFtpDir());
//		tree.setAttribute(FTPEpr.URL_TAG, "ftp://ftpuser:ftppassword@localhost/tmp");

		RemoteGatewayListener gateway = new RemoteGatewayListener(tree);
		boolean exception = false;

        gateway.initialise();
        gateway.start();

        try {
            try
            {
                gateway.deleteFile(new File("foo"));
            }
            catch (GatewayException ex)
            {
                exception = true;
            }

            if (!exception)
                fail();

            gateway.onSchedule();

            try
            {
                @SuppressWarnings("unused")
                byte[] contents = gateway.getFileContents(new File("bar"));

                fail();
            }
            catch (GatewayException ex)
            {
            }

            // TODO this ignores the parameter too!

            try
            {
                gateway.getFileList();
            }
            catch (GatewayException ex)
            {
                fail();
            }

            exception = false;

            try
            {
                gateway.deleteFile(new File("foo"));
            }
            catch (GatewayException ex)
            {
                exception = true;
            }

            if (!exception)
                fail();

            try
            {
                gateway.renameFile(new File("foo"), new File("bar"));

                fail();
            }
            catch (GatewayException ex)
            {
            }
        } finally {
            gateway.stop();
            gateway.destroy();
        }
    }
	
}
