/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.listeners.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collection;

import javax.xml.transform.stream.StreamSource;

import junit.framework.JUnit4TestAdapter;
import junit.framework.TestCase;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.testutils.TestEnvironmentUtil;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;

/**
 * XmlValidator unit tests.
 * @author <a href="mailto:ddegroff@ddegroff.com">ddegroff@ddegroff.com</a>
 */
public class XmlValidatorUnitTest extends TestCase {
	
	private Logger log = Logger.getLogger( XmlValidatorUnitTest.class );
	
	private static String testXml;
	private static InputSource inputSource;
	private static StreamSource validationSource;
	private static XmlValidatorImpl xmlValidation;
	private boolean isValid = false;
	
	@Override
	protected void setUp() throws Exception
	{
		testXml = "etc/examples/listeners/jbossesb_config_01.xml";
		File validationFile = new File(testXml);
		try {
			if (validationFile.exists()) {
				log.debug("validationFile "+testXml+" exists");
			} else {
				throw new IOException();
			}
		} catch (IOException e) {
			log.error("validationFile "+testXml+" does not exist");
		}
		try {
			InputStream inputStream = new FileInputStream(validationFile);
			inputSource = new InputSource(inputStream);
			xmlValidation = new XmlValidatorImpl(inputSource);
		} catch (Exception e) {
			log.error(e);
		}
		String validationFileName = TestEnvironmentUtil.getUserDir("product") 
			+ "etc/schemas/xml/jbossesb-1.0.1.xsd";
		try {
			validationSource = new StreamSource(validationFileName);
		} catch (Exception e) {
			log.error(e);
		}		
	}
	
	@Test 
	public void testValidateXml() throws Exception {
		isValid = xmlValidation.validate(inputSource);
		if (isValid) {
			log.debug(testXml+" is valid");
		} else {
			log.error(testXml+" is invalid -- see getValidationResults()");
			Collection<String> validationResults = xmlValidation.getValidationResults();

			if (validationResults.size() == 0) {
			} else {
				log.debug("Validation Results:");
				Object[] valResults = validationResults.toArray();
    		for (int i = 0; i < validationResults.size(); i++) {
        	log.debug(valResults[i].toString());
    		}
			}
		}
	}
	@Test
	public void testValidateXmlAndSchema() throws Exception {
		isValid = xmlValidation.validate(inputSource,validationSource);
		if (isValid) {
			log.debug(testXml+" is valid");
		} else {
			log.error(testXml+" is invalid -- see getValidationResults()");
			Collection<String> validationResults = xmlValidation.getValidationResults();

			if (validationResults.size() == 0) {
			} else {
				log.debug("Validation Results:");
				Object[] valResults = validationResults.toArray();
    		for (int i = 0; i < validationResults.size(); i++) {
        	log.debug(valResults[i].toString());
    		}
			}
		}
	}
	
	public void testValidateXmlAndDefaultSchema() throws Exception
	{
		isValid = xmlValidation.validate(inputSource, null);
		
		if (isValid)
		{
			log.debug(testXml+" is valid");
		} 
		else 
		{
			log.debug(testXml+" is invalid -- see getValidationResults()");
			Collection<String> validationResults = xmlValidation.getValidationResults();

			if (validationResults.size() == 0) 
			{
			} 
			else 
			{
				log.debug("Validation Results:");
				Object[] valResults = validationResults.toArray();
				
	    		for (int i = 0; i < validationResults.size(); i++) 
	    		{
	    			log.debug(valResults[i].toString());
	    		}
			}
		}
	}
	
	public void testXmlErrorHandler() throws Exception
	{
		XmlValidatorImpl foo = new XmlValidatorImpl();
		XmlValidatorImpl.XmlErrorHandler handler = foo.new XmlErrorHandler();
		
		handler.warning(new SAXParseException("foo", null));
		handler.error(new SAXParseException("foo", null));
		handler.fatalError(new SAXParseException("foo", null));
	}
	
	@Test
	public void testGetDocument() throws Exception {
		Document document = xmlValidation.getXMLDocument();
		if (document != null) {
			final StringWriter sWriter = new StringWriter() ;
			final OutputFormat format = new OutputFormat() ;
			format.setIndenting(true) ;
			final XMLSerializer xmlS = new XMLSerializer(sWriter, format) ;
			xmlS.asDOMSerializer() ;
			xmlS.serialize(document) ;
			log.debug(sWriter.toString()) ;
		}
	}
	@Test
	public void testGetValidationResults() throws Exception {
		if (isValid) {

		} else {
			Collection<String> validationResults = xmlValidation.getValidationResults();

			if (validationResults.size() == 0) {
			} else {
				log.debug("Validation Results:");
				Object[] valResults = validationResults.toArray();
    		for (int i = 0; i < validationResults.size(); i++) {
        	log.debug(valResults[i]);
    		}
			}
		}
	}
	
	public void testException () throws Exception
	{
		@SuppressWarnings("unused")
        XmlValidatorException ex = new XmlValidatorException("foobar");
		ex = new XmlValidatorException();
		ex = new XmlValidatorException("foobar", new Exception());
	}
		
	public static junit.framework.Test suite() {
		return new JUnit4TestAdapter(XmlValidatorUnitTest.class);
	}
	
}
