package org.jboss.soa.esb.listeners.config;

import java.io.IOException;
import java.util.List;

import junit.framework.TestCase;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleController;

/**
 * @author
 */
public class ServicePublisherUnitTest extends TestCase {

    public void test() throws ConfigurationException, IOException {
        Generator generator;
        ManagedLifecycleController controller1 = new ManagedLifecycleController(null); // TODO: Introduce an interface and Mock for ManagedLifecycleController
        ManagedLifecycleController controller2 = new ManagedLifecycleController(null); // TODO: Introduce an interface and Mock for ManagedLifecycleController

        generator = new Generator(getClass().getResourceAsStream("jbossesb_config_04.xml"));
        ServicePublisher.addServicePublishers(controller1, generator.getModel());
        List<ServicePublisher> publishers = ServicePublisher.getServicePublishers();
        assertEquals(2, publishers.size());
        assertEquals("A1", publishers.get(0).getCategory() + publishers.get(0).getServiceName());
        assertEquals(null, publishers.get(0).getContractPublisher());
        assertEquals("B2", publishers.get(1).getCategory() + publishers.get(1).getServiceName());
        assertEquals(null, publishers.get(1).getContractPublisher());

        generator = new Generator(getClass().getResourceAsStream("jbossesb_config_05.xml"));
        ServicePublisher.addServicePublishers(controller2, generator.getModel());
        publishers = ServicePublisher.getServicePublishers();
        assertEquals(4, publishers.size());
        assertEquals("A1", publishers.get(0).getCategory() + publishers.get(0).getServiceName());
        assertEquals(null, publishers.get(0).getContractPublisher());
        assertEquals("B2", publishers.get(1).getCategory() + publishers.get(1).getServiceName());
        assertEquals(null, publishers.get(1).getContractPublisher());
        assertEquals("C3", publishers.get(2).getCategory() + publishers.get(2).getServiceName());
        assertEquals(null, publishers.get(2).getContractPublisher());
        assertEquals("D4", publishers.get(3).getCategory() + publishers.get(3).getServiceName());
        assertTrue(publishers.get(3).getContractPublisher() instanceof MockContractPublisher);

        ServicePublisher.removeServicePublishers(controller1);
        publishers = ServicePublisher.getServicePublishers();
        assertEquals(2, publishers.size());
        assertEquals("C3", publishers.get(0).getCategory() + publishers.get(0).getServiceName());
        assertEquals(null, publishers.get(0).getContractPublisher());
        assertEquals("D4", publishers.get(1).getCategory() + publishers.get(1).getServiceName());
        assertTrue(publishers.get(1).getContractPublisher() instanceof MockContractPublisher);
    }
}
