/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.listeners;

import java.io.File;

import junit.framework.TestCase;

import org.jboss.soa.esb.ConfigurationException;

public class StandAloneBootStrapperUnitTest extends TestCase
{
	public void tearDown()
	{
		File serverLog = new File("server.log");
		if ( serverLog.exists() )
			serverLog.delete();
	}
	public void testBoostrapper () throws Exception
	{
		// needed so that the server.log file path in log4j.xml is correct
		System.setProperty( "jboss.server.log.dir", "." );
		String[] args = new String[0];
		
		try
		{
			StandAloneBootStrapper.main(args);
			fail();
		}
		catch (Exception ex)
		{
		}
		
		args = new String[2];
		
		args[0] = "gatewayExample.xml";
		args[1] = "5";
		
		try
		{
			StandAloneBootStrapper.main(args);
			
			fail();
		}
		catch (ConfigurationException ex)
		{
		}
		
		args[1] = "abc";
		
		try
		{
			StandAloneBootStrapper.main(args);			
			fail();
		}
		catch (Exception ex)
		{
		}
		
		args[0] = "install/conf/jbossesb.xml";
		args[1] = "5";
		
		try
		{
			StandAloneBootStrapper.main(args);		
		}
		catch (ConfigurationException ex)
		{
		}

		StandAloneBootStrapper bootstrapper = new StandAloneBootStrapper("install/conf/jbossesb.xml", "etc/schemas/xml/jbossesb-1.0.1.xsd");
		
		bootstrapper.requestEnd();
		bootstrapper.runAfter();
	}
	
}
