/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.helpers;

import java.io.IOException;

import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import junit.framework.TestCase;

/**
 * Tests for the EsbEmail class.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class EmailUnitTest extends TestCase {

	private ConfigTree mailParams;
	
	@Override
	protected void setUp() throws Exception {
		mailParams = ConfigTree.fromInputStream(getClass().getResourceAsStream("testfile4.xml"));
	}

	public void test_Email() throws AddressException, MessagingException, IOException {
		// Look at the source message in testfile4.xml before reading this test.
		
        Email esbMail = new Email();
        esbMail.setSendTo(mailParams.getAttribute(Email.SENDTO));
        esbMail.setFrom(mailParams.getAttribute(Email.FROM));
        esbMail.setCopyTo(mailParams.getAttribute(Email.COPYTO));
        esbMail.setSubject(mailParams.getAttribute(Email.SUBJECT));

        esbMail.setAttachments(mailParams.getTextChildren(Email.ATTACH));
        esbMail.setMessage(mailParams.getAttribute(Email.MESSAGE));
		MimeMessage message = esbMail.getMailMessage();
		Address[] addresses;

		// Check the "from" address details...
		addresses = message.getFrom();
		assertEquals(1, addresses.length);
		assertEquals("x.x@x.com", addresses[0].toString());
		
		// Check the "to" address details...
		addresses = message.getRecipients(MimeMessage.RecipientType.TO); 
		assertEquals(2, addresses.length);
		assertEquals("b.b@b.com", addresses[0].toString());
		assertEquals("c.c@c.com", addresses[1].toString());
		
		// Check the "cc" address details...
		addresses = message.getRecipients(MimeMessage.RecipientType.CC); 
		assertEquals(2, addresses.length);
		assertEquals("d.d@c.com", addresses[0].toString());
		assertEquals("e.e@e.com", addresses[1].toString());
		
		// Check the "subject"...
		assertEquals("Unit Test - Subject", message.getSubject());
		
		// Check the message body, including attachments...
		MimeMultipart content = (MimeMultipart) message.getContent(); // expect a cast exception if it's not the expected type!
		assertEquals(3, content.getCount()); // the message and the 2 attachments - see testfile4.xml
		MimeBodyPart part = (MimeBodyPart) content.getBodyPart(0); // the message
		assertEquals("Unit Test - Message", ((String)part.getContent()).trim());
		part = (MimeBodyPart) content.getBodyPart(1); // attachement 1
		assertEquals("attachment1.txt", ((String)part.getFileName()).trim());
		part = (MimeBodyPart) content.getBodyPart(2); // attachement 2
		assertEquals("attachment2.txt", ((String)part.getFileName()).trim());
	}
	
	// TODO: Add some negative tests!!!
}
