/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.util;

import junit.framework.TestCase;

/**
 * LRUCache tests.
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class LRUCacheUnitTest extends TestCase {

    public void test() {
        LRUCache<String, String> cache = new LRUCache<String, String>(4);

        cache.put("1", "one");
        cache.put("2", "two");
        cache.put("3", "three");
        cache.put("4", "four");

        cache.put("5", "five"); // should cause "1" to be removed
        assertEquals(4, cache.size());
        assertNull(cache.get("1"));

        cache.get("2"); //  should cause "2" to become the MRU and "3" to become the LRU
        cache.put("6", "six"); // should cause "3" to be removed
        assertEquals(4, cache.size());
        assertNull(cache.get("3"));
    }
}
