package org.jboss.internal.soa.esb.publish;

import junit.framework.TestCase;

/**
 * @author
 */
public class ContractInfoUnitTest extends TestCase {

    public void test() {
        assertContractorArgChecksOK(null, "a");
        assertContractorArgChecksOK(" ", "a");
        assertContractorArgChecksOK("a", null);
        assertContractorArgChecksOK("a", " ");

        ContractInfo contractInfo = new ContractInfo("mime", "data");
        assertEquals("mime", contractInfo.getMimeType());
        assertEquals("data", contractInfo.getData());
    }

    private void assertContractorArgChecksOK(String mimeType, String data) {
        try {
            new ContractInfo(mimeType, data);
            fail("Expected IllegalArgumentException");
        } catch(IllegalArgumentException e) {
            // Expected
        }
    }
}
