/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.internal.soa.esb.couriers.tests;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.UUID;

import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.addressing.eprs.FileEpr;
import org.jboss.soa.esb.common.tests.BaseTest;
import org.jboss.soa.esb.couriers.Courier;
import org.jboss.soa.esb.couriers.CourierFactory;
import org.jboss.soa.esb.couriers.TwoWayCourier;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.format.MessageFactory;

/**
 * Tests for internal FtpFileHandler class
 * 
 * @since Version 4.0
 * 
 */

public class CourierIntegrationTest extends BaseTest
{

	public void testDeliverFile () throws Exception
	{
		final File file = new File(System.getProperty("java.io.tmpdir")) ;
		deliver(file.toURL().toExternalForm());
		
		file.delete();
	}
	
	public void testDeliverFTP () throws Exception
	{
		if (getFtpPwd() != null)
			deliver("ftp://"+getFtpUser()+":"+getFtpPwd()+"@"+getFtpHostname()+"/"+getFtpDir());
		else
			deliver("ftp://"+getFtpUser()+"@"+getFtpHostname()+"/"+getFtpDir());
	}
	
	public void testPickupFile () throws Exception
	{
		final File file = new File(System.getProperty("java.io.tmpdir")) ;
		deliver(file.toURL().toExternalForm());
		
		pickup(file.toURL().toExternalForm());
		
		file.delete();
	}
	
	public void testPickupFTP () throws Exception
	{
		testDeliverFTP();
		
		if (getFtpPwd() != null)
			pickup("ftp://"+getFtpUser()+":"+getFtpPwd()+"@"+getFtpHostname()+"/"+getFtpDir());
		else
			pickup("ftp://"+getFtpUser()+"@"+getFtpHostname()+"/"+getFtpDir());
	}
	
	private final FileEpr getEpr(String sUrl) throws Exception
	{
		String protocol = new URL(sUrl).getProtocol();

		if ("ftp".equals(protocol))
			return new FTPEpr(sUrl);
		if ("file".equals(protocol))
			return new FileEpr(sUrl);

		throw new IllegalArgumentException("Not a recognised protocol!");
	}
	
	private final void pickup (String url) throws Exception
	{
		FileEpr epr = getEpr(url);
		epr.setInputSuffix(".esbMessage");
		epr.setPostDelete(true);
		TwoWayCourier courier = CourierFactory.getPickupCourier(epr);

		Message message = null;
		while (null != (message = courier.pickup(100)))
			System.out.println(message.getHeader().getCall().getMessageID());
	}

	private final void deliver (String url) throws Exception
	{
		Call call = new Call(getEpr(url));
		call.setMessageID(new URI(UUID.randomUUID().toString()));

		Message message = MessageFactory.getInstance().getMessage();
		message.getHeader().setCall(call);
		message.getBody().add("Hello World".getBytes());
		Courier courier = CourierFactory.getCourier(call.getTo());

		courier.deliver(message);
	}
}
