/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.couriers;

import java.util.Hashtable;
import java.util.Map;

import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierFactory;
import org.jboss.soa.esb.couriers.TwoWayCourier;

/**
 * Mock CourierFactory.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class MockCourierFactory extends CourierFactory {

    public static CourierException courierException;
    public static MalformedEPRException malformedEPRException;
    public static Hashtable<EPR, TwoWayCourier> couriers = new Hashtable<EPR, TwoWayCourier>();
    private static CourierFactory originalInstance;
    
    public TwoWayCourier getMessageCourier(EPR toEPR) throws CourierException, MalformedEPRException {
        if(courierException != null) {
            throw courierException;
        } else if(malformedEPRException != null) {
            throw malformedEPRException;
        }
        
        return couriers.get(toEPR);
    }

    public static void install() {
        originalInstance = CourierFactory.getInstance();
        CourierFactory.setInstance(new MockCourierFactory());
    }

    public static void uninstall() {
        CourierFactory.setInstance(originalInstance);
        reset();
    }

    public static void reset() {
        couriers.clear();
        courierException = null;
        malformedEPRException = null;
    }

    public static void resetCouriers() {
        for (Map.Entry<EPR, TwoWayCourier> entry : couriers.entrySet()) {
            ((MockCourier)entry.getValue()).reset();
        }
    }
}
