/**
 * 
 */
package org.jboss.soa.esb.services.persistence;

import java.net.URI;

/**
 * @author kstam
 *
 */
public interface RedeliverStore extends MessageStore
{
    public static final String DELIVER_COUNT           = "org.jboss.soa.esb.deliver.count";
    public static final String IS_REDELIVERY           = "org.jboss.soa.esb.deliver.isRedelivery";
    
    public Integer getMaxRedeliverCount();
    public void setMaxRedeliverCount(Integer maxRedeliverCount);
    /**
     * Tries to redeliver the message to it's destination. If delivery successfull the message record
     * is removed from the message store.
     * 
     * @param uid the unique message id
     * @throws MessageStoreException
     */
    public boolean redeliver(URI uid) throws MessageStoreException;
}
