/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */

package org.jboss.soa.esb.listeners.message.errors;

import java.net.URI;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.message.Fault;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;

public class Factory
{
	public static final String ERROR_ATTRIBUTE = "org.jboss.soa.esb.listeners.message.errors";
	
	public static final String PROCESSING_ERROR = "urn:action/error/actionprocessingerror";
	public static final String UNEXPECTED_ERROR = "urn:action/error/unexpectederror";
	public static final String NOT_ENABLED = "urn:action/error/disabled";
	
	public static void createExceptionFromFault (Message msg) throws FaultMessageException
	{
		String reason = msg.getFault().getReason();
		URI code = msg.getFault().getCode();
		Throwable cause = msg.getFault().getCause();
		
		if (cause == null)
			throw new FaultMessageException(reason, code, msg);
		else
			throw new FaultMessageException(reason, code, msg, cause);
	}
	
	public static Message createErrorMessage (String type, Message input, Throwable problem)
	{
		if (input == null)
			throw new IllegalArgumentException();
		
		Message errorMessage = MessageFactory.getInstance().getMessage(input.getType());
		
		if (errorMessage == null)
			throw new IllegalArgumentException("Could not create error message from "+input.getType());
		
		if (modifyMessage(input, errorMessage))
		{
			errorMessage.getBody().add(Fault.THROWABLE_CONTENT, problem);
			
			try
			{
				errorMessage.getFault().setCode(new URI(type));
				
				/*
				 * Is there an exception? If so, add the string as the reason.
				 */
				
				if (problem != null)
					errorMessage.getFault().setReason(problem.toString());
			}
			catch (final Exception ex)
			{
				_logger.debug("Caught exception "+ex+" during message creation!");
				
				return null;
			}
				
			return errorMessage;
		}
		else
			return input;
	}
	
	/**
	 * Where should the error message go? Check the header of the original
	 * input message.
	 */
	
	private final static boolean modifyMessage (Message input, Message errorMessage)
	{
		EPR destination = input.getHeader().getCall().getFaultTo();
		
		if ((destination == null) && (input.getHeader().getCall().getReplyTo() != null))
			destination = input.getHeader().getCall().getReplyTo();
		
		if ((destination == null) && (input.getHeader().getCall().getFrom() != null))
			destination = input.getHeader().getCall().getFrom();
		
		if (destination != null)
		{
			errorMessage.getHeader().getCall().setTo(destination);
			
			if (input.getHeader().getCall().getMessageID() != null)
				errorMessage.getHeader().getCall().setRelatesTo(input.getHeader().getCall().getMessageID());
			
			return true;
		}
		else
			return false;
	}
	
	private final static Logger _logger = Logger.getLogger(Factory.class);
}